USE master
GO

CREATE DATABASE ApplicationDB
GO

CREATE DATABASE DataWarehouse
GO

CREATE DATABASE ControlDB
GO

USE ApplicationDB
GO

CREATE TABLE Orders(
	OrderID				INT		IDENTITY(1,1),
	CustomerFirstName	VARCHAR(100),
	CustomerLastName	VARCHAR(100),
	ProductLine			VARCHAR(100),
	ProductName			VARCHAR(100),
	Quantity			INT,
	UnitPrice			DECIMAL(9,2),
	TotalPrice			DECIMAL(9,2)
)
GO

CREATE TABLE Sales(
	SalesID				INT		IDENTITY(1,1),
	OrderID				INT,
	SalesRegion			VARCHAR(100),
	ProductName			VARCHAR(100),
	TotalSalesAmount	DECIMAL(9,2)
)
GO

INSERT INTO Orders (CustomerFirstName,CustomerLastName,ProductName,ProductLine,Quantity,UnitPrice,TotalPrice) 
VALUES ('Harry','Potter','Magic Wand','Accessories',10,20,200)
INSERT INTO Orders (CustomerFirstName,CustomerLastName,ProductName,ProductLine,Quantity,UnitPrice,TotalPrice) 
VALUES ('Ron','Weasley','Flying Car','Others',1,400,400)
INSERT INTO Orders (CustomerFirstName,CustomerLastName,ProductName,ProductLine,Quantity,UnitPrice,TotalPrice) 
VALUES ('Hermoine','Granger','Potions Book','Study',2,50,100)
INSERT INTO Orders (CustomerFirstName,CustomerLastName,ProductName,ProductLine,Quantity,UnitPrice,TotalPrice) 
VALUES ('Draco','Malfoy','Magic Wand','Accessories',3,20,60)
GO

INSERT INTO Sales (OrderID,SalesRegion,ProductName,TotalSalesAmount)
VALUES (1,'London','Magic Wand',200)
INSERT INTO Sales (OrderID,SalesRegion,ProductName,TotalSalesAmount)
VALUES (2,'London','Flying Car',400)
INSERT INTO Sales (OrderID,SalesRegion,ProductName,TotalSalesAmount)
VALUES (3,'London','Potions Book',100)
INSERT INTO Sales (OrderID,SalesRegion,ProductName,TotalSalesAmount)
VALUES (4,'London','Magic Wand',60)
GO


USE DataWarehouse
GO

CREATE SCHEMA stage
GO

CREATE TABLE stage.Orders(
	OrderID				INT,
	CustomerFirstName	VARCHAR(100),
	CustomerLastName	VARCHAR(100),
	ProductLine			VARCHAR(100),
	ProductName			VARCHAR(100),
	Quantity			INT,
	UnitPrice			DECIMAL(9,2),
	TotalPrice			DECIMAL(9,2)
)
GO

CREATE TABLE stage.Sales(
	SalesID				INT,
	OrderID				INT,
	SalesRegion			VARCHAR(100),
	ProductName			VARCHAR(100),
	TotalSalesAmount	DECIMAL(9,2)
)
GO

CREATE TABLE DimCustomer(
	CustomerID				INT				IDENTITY(1,1),
	CustomerFirstName		VARCHAR(100),
	CustomerLastName		VARCHAR(100),
	CustomerFullName		VARCHAR(255)
)
GO

CREATE TABLE DimProduct(
	ProductID				INT				IDENTITY(1,1),
	ProductLine				VARCHAR(100),
	ProductName				VARCHAR(100),
	UnitPrice				DECIMAL(9,0)
)
GO

CREATE TABLE DimRegion(
	RegionID				INT				IDENTITY(1,1),
	RegionName				VARCHAR(100)
)
GO

CREATE TABLE FactOrders(
	FactOrderID				INT				IDENTITY(1,1),
	CustomerID				INT,
	ProductID				INT,
	UnitPrice				DECIMAL(9,0),
	Quantity				INT,
	TotalPrice				DECIMAL(9,0)
)
GO

CREATE TABLE FactSales(
	FactSalesID				INT				IDENTITY(1,1),
	OrderID					INT,
	RegionID				INT,
	ProductID				INT,
	SalesAmount				DECIMAL(9,0)
)
GO


CREATE PROCEDURE usp_Populate_Orders
AS

	INSERT INTO DimCustomer (CustomerFirstName,CustomerLastName,CustomerFullName)
	SELECT DISTINCT
		CustomerFirstName,
		CustomerLastName,
		CustomerFirstName + ' ' + CustomerLastName AS CustomerFullName
	FROM stage.Orders

	
	INSERT INTO DimProduct (ProductLine,ProductName,UnitPrice)
	SELECT DISTINCT
		ProductLine,
		ProductName,
		UnitPrice
	FROM stage.Orders

	INSERT INTO FactOrders(CustomerID,ProductID,UnitPrice,Quantity,TotalPrice)
	SELECT
		dc.CustomerID,
		dp.ProductID,
		dp.UnitPrice,
		ord.Quantity,
		ord.TotalPrice
	FROM stage.Orders ord
	LEFT OUTER JOIN DimCustomer dc	ON dc.CustomerFirstName = ord.CustomerFirstName
	LEFT OUTER JOIN DimProduct dp	ON dp.ProductName = ord.ProductName
GO


CREATE PROCEDURE usp_Populate_Sales
AS

	INSERT INTO DimRegion (RegionName)
	SELECT DISTINCT
		SalesRegion
	FROM stage.Sales


	INSERT INTO FactSales(OrderID,RegionID,ProductID,SalesAmount)
	SELECT
		sales.OrderID,
		dr.RegionID,
		dp.ProductID,
		sales.TotalSalesAmount
	FROM stage.Sales sales
	LEFT OUTER JOIN DimRegion dr	ON dr.RegionName = sales.SalesRegion
	LEFT OUTER JOIN DimProduct dp	ON dp.ProductName = sales.ProductName
GO




USE ControlDB
GO

CREATE TABLE ExecutionLog(
	ExecutionID				INT				IDENTITY(1,1),
	PackageName				VARCHAR(100),
	ProcessName				VARCHAR(100),
	CreatedDateTime			DATETIME,
)
GO