--Step 1: Database Master Key (DMK) on the primary replica
USE master
GO
SELECT * FROM
sys.symmetric_keys
WHERE name = '##MS_DatabaseMasterKey##'

--In case you do not have a master key, create it using the following script.
 
USE master
GO
CREATE MASTER KEY ENCRYPTION
BY PASSWORD='P@ssw0rd123';
GO

--Step 2: Create the Certificate for the AG database on the primary replica

USE master;
GO
CREATE CERTIFICATE TDECert WITH SUBJECT = 'Certificate for TDE'
GO
--Verify certificate
SELECT name, pvt_key_encryption_type_desc,issuer_name,subject,expiry_date,start_date,key_length
FROM sys.certificates WHERE name = 'TDECert'
GO

-- Create a Database Encryption Key on the AG database

USE DBARepository
GO
CREATE DATABASE ENCRYPTION KEY
   WITH Algorithm = AES_128
   ENCRYPTION BY Server Certificate TDECert;

--Backup the certificate on Primary replica

Use Master
Go
BACKUP CERTIFICATE TDECert
TO FILE='C:\temp\TDECert'
WITH PRIVATE KEY (FILE='C:\temp\TDECert_private',
ENCRYPTION BY PASSWORD='P@ssw0rd123')
GO

--Create secondary replica certificate from the primary replica certificate

CREATE CERTIFICATE SQLAG2_TDE_certificate
   FROM FILE = 'C:\temp\TDECert'
   WITH Private KEY (
       FILE = 'C:\temp\TDECert_private',
       Decryption BY Password = 'P@ssw0rd123');

--Enable TDE encryption on primary replica

ALTER DATABASE DBARepository SET ENCRYPTION ON

--Monitor TDE encryption
USE MASTER;
GO
SELECT db.name,db.is_encrypted,dm.encryption_state,dm.percent_complete,
dm.key_algorithm,dm.key_length
FROM sys.databases db
LEFT OUTER JOIN 
sys.dm_database_encryption_keys dm
ON db.database_id = dm.database_id;
GO

----Monitor TDE encryption with case statement

SELECT DB_NAME(database_id) AS DatabaseName, encryption_state,
encryption_state_desc =
CASE encryption_state
         WHEN '0'  THEN  'No database encryption key present, no encryption'
         WHEN '1'  THEN  'Unencrypted'
         WHEN '2'  THEN  'Encryption in progress'
         WHEN '3'  THEN  'Encrypted'
         WHEN '4'  THEN  'Key change in progress'
         WHEN '5'  THEN  'Decryption in progress'
         WHEN '6'  THEN  'Protection change in progress (The certificate or asymmetric key that is encrypting the database encryption key is being changed.)'
         ELSE 'No Status'
         END,
percent_complete,encryptor_thumbprint, encryptor_type  FROM sys.dm_database_encryption_keys