
SELECT [Server_Name] = SERVERPROPERTY('servername'), 
       [SQL Version] = CASE
                           WHEN @@VERSION LIKE '%2000%8.%'
                           THEN '2000'
                           WHEN @@VERSION LIKE '%2005%9.%'
                           THEN '2005'
                           WHEN @@VERSION LIKE '%2008%10.0%'
                           THEN '2008'
                           WHEN @@VERSION LIKE '%2008 R2%10.5%'
                           THEN '2008 R2'
                           WHEN @@VERSION LIKE '%2012%11.%'
                           THEN '2012'
                           WHEN @@VERSION LIKE '%2014%12.%'
                           THEN '2014'
                           WHEN @@VERSION LIKE '%2016%13.%'
                           THEN '2016'
                           WHEN @@VERSION LIKE '%2017%14.%'
                           THEN '2017'
                           WHEN @@VERSION LIKE '%2019%15.%'
                           THEN '2019'
                       END, 
       [DB Name] = name, 
       [Status] = DATABASEPROPERTYEX(name, 'Status'), 
       [Updateability] = DATABASEPROPERTYEX(name, 'Updateability'), 
       [UserAccess] = DATABASEPROPERTYEX(name, 'UserAccess'), 
       [DB Owner] = SUSER_SNAME(sid), 
       [Collation] = DATABASEPROPERTYEX(name, 'Collation'), 
       [ComparisonStyle] = DATABASEPROPERTYEX(name, 'ComparisonStyle'), 
       [IsAnsiNullDefault] = CASE
                                 WHEN DATABASEPROPERTYEX(name, 'IsAnsiNullDefault') = 1
                                 THEN 'TRUE'
                                 WHEN DATABASEPROPERTYEX(name, 'IsAnsiNullDefault') = 0
                                 THEN 'FALSE'
                                 ELSE DATABASEPROPERTYEX(name, 'IsAnsiNullDefault')
                             END, 
       [IsAnsiNullsEnabled] = CASE
                                  WHEN DATABASEPROPERTYEX(name, 'IsAnsiNullsEnabled') = 1
                                  THEN 'TRUE'
                                  WHEN DATABASEPROPERTYEX(name, 'IsAnsiNullsEnabled') = 0
                                  THEN 'FALSE'
                                  ELSE DATABASEPROPERTYEX(name, 'IsAnsiNullsEnabled')
                              END, 
       [IsAnsiPaddingEnabled] = CASE
                                    WHEN DATABASEPROPERTYEX(name, 'IsAnsiPaddingEnabled') = 1
                                    THEN 'TRUE'
                                    WHEN DATABASEPROPERTYEX(name, 'IsAnsiPaddingEnabled') = 0
                                    THEN 'FALSE'
                                    ELSE DATABASEPROPERTYEX(name, 'IsAnsiPaddingEnabled')
                                END, 
       [IsAnsiWarningsEnabled] = CASE
                                     WHEN DATABASEPROPERTYEX(name, 'IsAnsiWarningsEnabled') = 1
                                     THEN 'TRUE'
                                     WHEN DATABASEPROPERTYEX(name, 'IsAnsiWarningsEnabled') = 0
                                     THEN 'FALSE'
                                     ELSE DATABASEPROPERTYEX(name, 'IsAnsiWarningsEnabled')
                                 END, 
       [IsArithmeticAbortEnabled] = CASE
                                        WHEN DATABASEPROPERTYEX(name, 'IsArithmeticAbortEnabled') = 1
                                        THEN 'TRUE'
                                        WHEN DATABASEPROPERTYEX(name, 'IsArithmeticAbortEnabled') = 0
                                        THEN 'FALSE'
                                        ELSE DATABASEPROPERTYEX(name, 'IsArithmeticAbortEnabled')
                                    END, 
       [IsAutoClose] = CASE
                           WHEN DATABASEPROPERTYEX(name, 'IsAutoClose') = 1
                           THEN 'TRUE'
                           WHEN DATABASEPROPERTYEX(name, 'IsAutoClose') = 0
                           THEN 'FALSE'
                           ELSE DATABASEPROPERTYEX(name, 'IsAutoClose')
                       END, 
       [IsAutoCreateStatistics] = CASE
                                      WHEN DATABASEPROPERTYEX(name, 'IsAutoCreateStatistics') = 1
                                      THEN 'TRUE'
                                      WHEN DATABASEPROPERTYEX(name, 'IsAutoCreateStatistics') = 0
                                      THEN 'FALSE'
                                      ELSE DATABASEPROPERTYEX(name, 'IsAutoCreateStatistics')
                                  END, 
       [IsAutoCreateStatisticsIncremental] = CASE
                                                 WHEN DATABASEPROPERTYEX(name, 'IsAutoCreateStatisticsIncremental') = 1
                                                 THEN 'TRUE'
                                                 WHEN DATABASEPROPERTYEX(name, 'IsAutoCreateStatisticsIncremental') = 0
                                                 THEN 'FALSE'
                                                 ELSE '*** Feature Supported from SQL 2014****'
                                             END, 
       [IsAutoShrink] = CASE
                            WHEN DATABASEPROPERTYEX(name, 'IsAutoShrink') = 1
                            THEN 'TRUE'
                            WHEN DATABASEPROPERTYEX(name, 'IsAutoShrink') = 0
                            THEN 'FALSE'
                            ELSE DATABASEPROPERTYEX(name, 'IsAutoShrink')
                        END, 
       [IsAutoUpdateStatistics] = CASE
                                      WHEN DATABASEPROPERTYEX(name, 'IsAutoUpdateStatistics') = 1
                                      THEN 'TRUE'
                                      WHEN DATABASEPROPERTYEX(name, 'IsAutoUpdateStatistics') = 0
                                      THEN 'FALSE'
                                      ELSE DATABASEPROPERTYEX(name, 'IsAutoUpdateStatistics')
                                  END, 
       [IsClone] = CASE
                       WHEN DATABASEPROPERTYEX(name, 'IsClone') = 1
                       THEN 'TRUE'
                       WHEN DATABASEPROPERTYEX(name, 'IsClone') = 0
                       THEN 'FALSE'
                       ELSE '*** Feature Supported from SQL 2014****'
                   END, 
       [IsCloseCursorsOnCommitEnabled] = CASE
                                             WHEN DATABASEPROPERTYEX(name, 'IsCloseCursorsOnCommitEnabled') = 1
                                             THEN 'TRUE'
                                             WHEN DATABASEPROPERTYEX(name, 'IsCloseCursorsOnCommitEnabled') = 0
                                             THEN 'FALSE'
                                             ELSE DATABASEPROPERTYEX(name, 'IsCloseCursorsOnCommitEnabled')
                                         END, 
       [IsFulltextEnabled] = CASE
                                 WHEN DATABASEPROPERTYEX(name, 'IsFulltextEnabled') = 1
                                 THEN 'TRUE'
                                 WHEN DATABASEPROPERTYEX(name, 'IsFulltextEnabled') = 0
                                 THEN 'FALSE'
                                 ELSE DATABASEPROPERTYEX(name, 'IsFulltextEnabled')
                             END, 
       [IsInStandBy] = CASE
                           WHEN DATABASEPROPERTYEX(name, 'IsInStandBy') = 1
                           THEN 'TRUE'
                           WHEN DATABASEPROPERTYEX(name, 'IsInStandBy') = 0
                           THEN 'FALSE'
                           ELSE DATABASEPROPERTYEX(name, 'IsInStandBy')
                       END, 
       [IsLocalCursorsDefault] = CASE
                                     WHEN DATABASEPROPERTYEX(name, 'IsLocalCursorsDefault') = 1
                                     THEN 'TRUE'
                                     WHEN DATABASEPROPERTYEX(name, 'IsLocalCursorsDefault') = 0
                                     THEN 'FALSE'
                                     ELSE DATABASEPROPERTYEX(name, 'IsLocalCursorsDefault')
                                 END, 
       [IsMemoryOptimizedElevateToSnapshotEnabled] = CASE
                                                         WHEN DATABASEPROPERTYEX(name, 'IsMemoryOptimizedElevateToSnapshotEnabled') = 1
                                                         THEN 'TRUE'
                                                         WHEN DATABASEPROPERTYEX(name, 'IsMemoryOptimizedElevateToSnapshotEnabled') = 0
                                                         THEN 'FALSE'
                                                         ELSE '*** Feature Supported from SQL 2014****'
                                                     END, 
       [IsMergePublished] = CASE
                                WHEN DATABASEPROPERTYEX(name, 'IsMergePublished') = 1
                                THEN 'TRUE'
                                WHEN DATABASEPROPERTYEX(name, 'IsMergePublished') = 0
                                THEN 'FALSE'
                                ELSE DATABASEPROPERTYEX(name, 'IsMergePublished')
                            END, 
       [IsNullConcat] = CASE
                            WHEN DATABASEPROPERTYEX(name, 'IsNullConcat') = 1
                            THEN 'TRUE'
                            WHEN DATABASEPROPERTYEX(name, 'IsNullConcat') = 0
                            THEN 'FALSE'
                            ELSE DATABASEPROPERTYEX(name, 'IsNullConcat')
                        END, 
       [IsNumericRoundAbortEnabled] = CASE
                                          WHEN DATABASEPROPERTYEX(name, 'IsNumericRoundAbortEnabled') = 1
                                          THEN 'TRUE'
                                          WHEN DATABASEPROPERTYEX(name, 'IsNumericRoundAbortEnabled') = 0
                                          THEN 'FALSE'
                                          ELSE DATABASEPROPERTYEX(name, 'IsNumericRoundAbortEnabled')
                                      END, 
       [IsParameterizationForced] = CASE
                                        WHEN DATABASEPROPERTYEX(name, 'IsParameterizationForced') = 1
                                        THEN 'TRUE'
                                        WHEN DATABASEPROPERTYEX(name, 'IsParameterizationForced') = 0
                                        THEN 'FALSE'
                                        ELSE DATABASEPROPERTYEX(name, 'IsParameterizationForced')
                                    END, 
       [IsPublished] = CASE
                           WHEN DATABASEPROPERTYEX(name, 'IsPublished') = 1
                           THEN 'TRUE'
                           WHEN DATABASEPROPERTYEX(name, 'IsPublished') = 0
                           THEN 'FALSE'
                           ELSE DATABASEPROPERTYEX(name, 'IsPublished')
                       END, 
       [IsQuotedIdentifiersEnabled] = CASE
                                          WHEN DATABASEPROPERTYEX(name, 'IsQuotedIdentifiersEnabled') = 1
                                          THEN 'TRUE'
                                          WHEN DATABASEPROPERTYEX(name, 'IsQuotedIdentifiersEnabled') = 0
                                          THEN 'FALSE'
                                          ELSE DATABASEPROPERTYEX(name, 'IsQuotedIdentifiersEnabled')
                                      END, 
       [IsRecursiveTriggersEnabled] = CASE
                                          WHEN DATABASEPROPERTYEX(name, 'IsRecursiveTriggersEnabled') = 1
                                          THEN 'TRUE'
                                          WHEN DATABASEPROPERTYEX(name, 'IsRecursiveTriggersEnabled') = 0
                                          THEN 'FALSE'
                                          ELSE DATABASEPROPERTYEX(name, 'IsRecursiveTriggersEnabled')
                                      END, 
       [IsSubscribed] = CASE
                            WHEN DATABASEPROPERTYEX(name, 'IsSubscribed') = 1
                            THEN 'TRUE'
                            WHEN DATABASEPROPERTYEX(name, 'IsSubscribed') = 0
                            THEN 'FALSE'
                            ELSE DATABASEPROPERTYEX(name, 'IsSubscribed')
                        END, 
       [IsSyncWithBackup] = CASE
                                WHEN DATABASEPROPERTYEX(name, 'IsSyncWithBackup') = 1
                                THEN 'TRUE'
                                WHEN DATABASEPROPERTYEX(name, 'IsSyncWithBackup') = 0
                                THEN 'FALSE'
                                ELSE DATABASEPROPERTYEX(name, 'IsSyncWithBackup')
                            END, 
       [IsTornPageDetectionEnabled] = CASE
                                          WHEN DATABASEPROPERTYEX(name, 'IsTornPageDetectionEnabled') = 1
                                          THEN 'TRUE'
                                          WHEN DATABASEPROPERTYEX(name, 'IsTornPageDetectionEnabled') = 0
                                          THEN 'FALSE'
                                          ELSE DATABASEPROPERTYEX(name, 'IsTornPageDetectionEnabled')
                                      END, 
       [IsVerifiedClone] = CASE
                               WHEN DATABASEPROPERTYEX(name, 'IsVerifiedClone') = 1
                               THEN 'TRUE'
                               WHEN DATABASEPROPERTYEX(name, 'IsVerifiedClone') = 0
                               THEN 'FALSE'
                               ELSE '*** Feature Supported from SQL 2016****'
                           END, 
       [IsXTPSupported] = CASE
                              WHEN DATABASEPROPERTYEX(name, 'IsXTPSupported') = 1
                              THEN 'TRUE'
                              WHEN DATABASEPROPERTYEX(name, 'IsXTPSupported') = 0
                              THEN 'FALSE'
                              ELSE '*** Feature Supported from SQL 2016****'
                          END, 
       [IsXTPSupported] = CASE
                              WHEN DATABASEPROPERTYEX(name, 'IsXTPSupported') = 1
                              THEN 'TRUE'
                              WHEN DATABASEPROPERTYEX(name, 'IsXTPSupported') = 0
                              THEN 'FALSE'
                              ELSE '*** Feature Supported from SQL 2016****'
                          END, 
       [LastGoodCheckDbTime] = CASE
                                   WHEN DATABASEPROPERTYEX(name, 'LastGoodCheckDbTime') IS NULL
                                   THEN '*** Feature Supported from SQL 2016****'
                                   ELSE DATABASEPROPERTYEX(name, 'LastGoodCheckDbTime')
                               END, 
       [LCID] = DATABASEPROPERTYEX(name, 'LCID'), 
       [Recovery] = DATABASEPROPERTYEX(name, 'Recovery'), 
       [SQLSortOrder] = DATABASEPROPERTYEX(name, 'SQLSortOrder'), 
       [Version] = DATABASEPROPERTYEX(name, 'Version')
FROM master.sys.sysdatabases;