ALTER TRIGGER alert_table
ON database
FOR CREATE_TABLE, DROP_TABLE, ALTER_TABLE
AS 
BEGIN
	IF IS_MEMBER ('db_owner') = 0
	BEGIN
		PRINT 'Please contact your Database Administrator' 

		DECLARE @alert_subject VARCHAR(1024);
		SET @alert_subject = 'Table - DDL Command Error - '+ CAST(GETDATE() AS VARCHAR(100));
		
		DECLARE @event_data XML = EVENTDATA()

		DECLARE @body_html VARCHAR(MAX)
		SET @body_html = '<html><body><H3>Trigger Event Info</H3> <table border = 1>
							<tr> <th> EventType </th> <th> PostTime </th> <th> ServerName </th> <th> LoginName </th>
							<th> UserName </th> <th> DatabaseName </th> <th> SchemaName </th> <th> ObjectName </th> 
							<th> ObjectType </th> <th> TSQLCommand </th></tr>'	+
						CAST(( SELECT  
								Tbl.Col.value('EventType[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('PostTime[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('ServerName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('LoginName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('UserName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('DatabaseName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('SchemaName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('ObjectName[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('ObjectType[1]', 'VARCHAR(128)') AS 'td', '',
								Tbl.Col.value('TSQLCommand[1]', 'VARCHAR(MAX)') AS 'td', ''
							FROM  @event_data.nodes('//EVENT_INSTANCE') Tbl(Col) 
							FOR XML PATH('tr'), ELEMENTS ) AS NVARCHAR(MAX))	+
						'</table></body></html>'

			EXEC msdb.dbo.sp_send_dbmail
				@profile_name = 'Database Administrator Alert',
				@recipients = 'dba.group@test.com',
				@body = @body_html,
				@subject = @alert_subject

	ROLLBACK TRANSACTION;
	END
END
GO
