-- Data Science Data Understanding and Preparation Part 8:
-- Pivoting and Transposing Data

USE AdventureWorksDW2017;
GO

-- Data preparation
SELECT g.EnglishCountryRegionName AS Country,
 g.StateProvinceName AS State,
 g.EnglishCountryRegionName + ' ' + g.StateProvinceName AS CountryState,
 d.CalendarYear AS CYear,
 SUM(s.SalesAmount) AS Sales
INTO dbo.SalesGeoYear
FROM dbo.FactInternetSales s
 INNER JOIN dbo.DimDate d
  ON d.DateKey = s.OrderDateKey
 INNER JOIN dbo.DimCustomer c
  ON c.CustomerKey = s.CustomerKey
 INNER JOIN dbo.DimGeography g
  ON g.GeographyKey = c.GeographyKey
WHERE g.EnglishCountryRegionName IN (N'Australia', N'Canada')
GROUP BY
 g.EnglishCountryRegionName,
 g.StateProvinceName,
 d.CalendarYear;
GO

SELECT TOP 5 *
FROM dbo.SalesGeoYear;
SELECT DISTINCT CYear
FROM dbo.SalesGeoYear;
GO

-- PIVOT operator
-- Sum
WITH PCTE AS
(
SELECT Country, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT Country, [2010], [2011], [2012], [2013], [2014]
FROM PCTE
 PIVOT (SUM(Sales) FOR CYear
    IN ([2010], [2011], [2012], [2013], [2014])) AS P;
-- Count
WITH PCTE AS
(
SELECT Country, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT Country, [2010], [2011], [2012], [2013], [2014]
FROM PCTE
 PIVOT (COUNT(Sales) FOR CYear
    IN ([2010], [2011], [2012], [2013], [2014])) AS P;

-- Problem without a subquery - implicit grouping
WITH PCTE AS
(
SELECT Country, State, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT Country, [2010], [2011], [2012], [2013], [2014]
FROM PCTE
 PIVOT (SUM(Sales) FOR CYear
    IN ([2010], [2011], [2012], [2013], [2014])) AS P;

-- PIVOT must have an aggregate function
-- This does not work
WITH PCTE AS
(
SELECT CountryState, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT CountryState, [2010], [2011], [2012], [2013], [2014]
FROM PCTE
 PIVOT (Sales FOR CYear
    IN ([2010], [2011], [2012], [2013], [2014])) AS P;
-- Correct
WITH PCTE AS
(
SELECT CountryState, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT CountryState, [2010], [2011], [2012], [2013], [2014]
FROM PCTE
 PIVOT (MAX(Sales) FOR CYear
    IN ([2010], [2011], [2012], [2013], [2014])) AS P;

-- Without PIVOT operator
SELECT Country, 
 SUM(CASE WHEN CYear = 2010 THEN Sales END) AS [2010], 
 SUM(CASE WHEN CYear = 2011 THEN Sales END) AS [2011], 
 SUM(CASE WHEN CYear = 2012 THEN Sales END) AS [2012], 
 SUM(CASE WHEN CYear = 2013 THEN Sales END) AS [2013], 
 SUM(CASE WHEN CYear = 2014 THEN Sales END) AS [2014]
FROM dbo.SalesGeoYear
GROUP BY Country;
GO

-- Dynamic pivot
DECLARE @stmtvar AS NVARCHAR(4000);
SET @stmtvar = N'
WITH PCTE AS
(
SELECT Country, CYear, Sales
FROM dbo.SalesGeoYear
)
SELECT *
FROM PCTE
 PIVOT (SUM(Sales) FOR CYear
    IN ('
+
(SELECT STRING_AGG(Cyear, N', ') WITHIN GROUP (ORDER BY CYear)
FROM
 (	
 SELECT DISTINCT QUOTENAME(CYear) AS CYear
 FROM dbo.SalesGeoYear
 ) AS Y)
+ N')) AS P;';	
EXEC sys.sp_executesql @stmt = @stmtvar;
GO


-- Clean up
DROP TABLE dbo.SalesGeoYear;
GO

