# Data Science Data Understanding and Preparation Part 8:
# Pivoting and Transposing Data

# Imports needed
import numpy as np
import pandas as pd
import pyodbc
import matplotlib.pyplot as plt

# Connecting and reading the data
con = pyodbc.connect('DSN=AWDW;UID=RUser;PWD=Pa$$w0rd')
query = """
SELECT Country, State, CountryState, CYear, Sales
FROM dbo.SalesGeoYear;"""
SGY = pd.read_sql(query, con)
SGY.head()

# Simple transpose
SGY.transpose()
# The property T is an accessor to the method transpose()
SGY.T

# Changing the index and tranposing
SNA = SGY.copy()
SNA.set_index(["CountryState", "CYear"], inplace = True)
SNA.T


# Pivoting - no aggregations
SGY.pivot(index = "CountryState", columns = "CYear", values = "Sales")
# Unstack
cols = ["CountryState", "CYear", "Sales"]
SNA = pd.DataFrame(SGY, columns = cols)
SNA.set_index(["CountryState", "CYear"], inplace = True)
SNA.unstack("CYear")


# Pivot table - with aggregations
SGY.pivot_table(values = "Sales", index = "Country",
               columns = "CYear", aggfunc = "sum")
SGY.pivot_table(values = "Sales", index = "Country",
               columns = "CYear", aggfunc = "count")

# Showing the bar chart
SGY.pivot_table(values = "Sales", index = "Country",
                columns = "CYear", aggfunc = "count").plot(kind = "barh")
plt.show()
