#region Namespaces
using Microsoft.AnalysisServices.Tabular;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
#endregion


namespace ST_aeb3e42bfdbe42e1a334f8e5ff73f223
{
	[Microsoft.SqlServer.Dts.Tasks.ScriptTask.SSISScriptTaskEntryPointAttribute]
	public partial class ScriptMain : Microsoft.SqlServer.Dts.Tasks.ScriptTask.VSTARTScriptObjectModelBase
	{
        public void Main()
        {
            string Audit_Key = Convert.ToString(11);

            string Tabular_Database_Name = Convert.ToString(Dts.Variables["User::Tabular_Database_Name"].Value);
            string Tabular_Table_Name = Convert.ToString(Dts.Variables["User::Table_Name"].Value);
            string Tabular_Partition_Pattern_Name = Tabular_Table_Name + " - pattern";

            //Define SQL Server connection
            string SQL_ConnStr = Convert.ToString(Dts.Variables["User::ConnStr_Configuration_Database"].Value);
            DataTable PartitionList = new DataTable();

            //load list of required partitions into data table
            string SQL_GetPartitionList = @"
                SELECT	Tabular_Database_Name, Table_Name, Partition_Name, Partition_Filter,
		                Partition_Action_Flag
                FROM	ETL_Tabular_Partitions_Required
                WHERE	Audit_Key = " + Audit_Key;

            using (SqlConnection conn_Config_Database = new SqlConnection(SQL_ConnStr))
            {
                conn_Config_Database.Open();

                SqlCommand GetPartitionList = new SqlCommand(SQL_GetPartitionList, conn_Config_Database);

                SqlDataAdapter da = new SqlDataAdapter(GetPartitionList);
                da.Fill(PartitionList);
                conn_Config_Database.Close();
                da.Dispose();
            }

                        
            //connect to tabular model
            var Tabular_Server = new Server();
            string Tabular_ConnStr = Convert.ToString(Dts.Variables["User::ConnStr_Tabular_Database"].Value);

            Tabular_Server.Connect(Tabular_ConnStr);
            Database Tabular_Db = Tabular_Server.Databases[Tabular_Database_Name];
            Model Tabular_Model = Tabular_Db.Model;
            Table Tabular_Table = Tabular_Model.Tables[Tabular_Table_Name];
            DataSource Tabular_DataSource = Tabular_Model.DataSources[0];
            //DataSource Tabular_DataSource = Tabular_Model.DataSources.Find("your data source name");

            //get the baseline query without WHERE
            Partition Pattern_Partition = Tabular_Table.Partitions.Find(Tabular_Partition_Pattern_Name);
            string Partition_Pattern_Query = ((Microsoft.AnalysisServices.Tabular.QueryPartitionSource)(Pattern_Partition.Source.Partition).Source).Query.ToString();
            Partition_Pattern_Query = Partition_Pattern_Query.Substring(0, Partition_Pattern_Query.Length - 9); //to strip off the "WHERE 1=2"

            
            // create the partitions based on the loaded list
            foreach (DataRow Partition in PartitionList.Rows)
            {

                string Partition_Action_Flag = Convert.ToString(Partition["Partition_Action_Flag"]);

                switch (Partition_Action_Flag)
                {
                    case "Create":
                        var NewDataPartition = new Partition
                        {
                            Name = Convert.ToString(Partition["Partition_Name"]),
                            DataView = DataViewType.Full,
                            Source = new QueryPartitionSource
                            {
                                DataSource = Tabular_DataSource,
                                Query = Partition_Pattern_Query + Convert.ToString(Partition["Partition_Filter"])
                            }

                        };

                        Tabular_Table.Partitions.Add(NewDataPartition);

                        break;

                    case "Delete":
                        Tabular_Table.Partitions.Remove(Convert.ToString(Partition["Partition_Name"]));
                        break;

                    case "Process":
                        Tabular_Table.Partitions[Convert.ToString(Partition["Partition_Name"])].RequestRefresh(RefreshType.Full);
                        break;
                }

                Tabular_Model.SaveChanges();
                
            }

        }
    }
}
