/*requires Schema.Common.sql*/
/*requires Table.Common.ApplicationParams.sql*/

DECLARE @ProcedureName NVARCHAR(128) = '[Common].[getApplicationParam]';
PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT 'Procedure ' + @ProcedureName;

IF  NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(@ProcedureName) AND type in (N'P'))
BEGIN
    EXECUTE ('CREATE PROCEDURE '+ @ProcedureName + ' ' +
            'AS ' +
            'BEGIN ' +
            '   RETURN ''Not implemented'' ' +
            'END');

    IF @@ERROR = 0
        PRINT '   Procedure '+ @ProcedureName + ' created.';
    ELSE
    BEGIN
        PRINT '   Error while trying to create procedure '+ @ProcedureName;
        RETURN;
    END;
END;
GO

ALTER PROCEDURE [Common].[getApplicationParam] (
    @ApplicationName        VARCHAR(128) = '$(SolutionName)',
    @ParamName              VARCHAR(64),
    @ParamValue             VARCHAR(max) OUTPUT,
    @Debug                  BIT = 0    
)
AS
/*
    Example Usage : 
    
        DECLARE @Version varchar(max);
        exec [Common].[getApplicationParam] @ApplicationName = 'MyApp', @ParamName = 'version' , @ParamValue = @Version OUTPUT;
        PRINT @Version ;
*/
BEGIN 
    SET NOCOUNT ON;    
    
    DECLARE @ThisProc       VARCHAR(1024);
    SET @ThisProc = DB_NAME() + '.' + OBJECT_SCHEMA_NAME(@@PROCID) + OBJECT_NAME(@@PROCID) ;

    if(@Debug = 1)
    BEGIN
        PRINT 'Now Running ' + @ThisProc;
    END;
    
    IF(LEN(@ApplicationName) = 0)
    BEGIN 
        RAISERROR('Parameter @ApplicationName is empty',12,1) WITH NOWAIT;
    END ;
    
    IF(LEN(@ParamName) = 0)
    BEGIN 
        RAISERROR('Parameter @ParamName is empty',12,1) WITH NOWAIT;
    END ;
    
    DECLARE @CurParamVal    VARCHAR(MAX);
    DECLARE @CurParamDflt   VARCHAR(MAX);
    DECLARE @NullableValue  BIT;
    DECLARE @Depreciated    BIT;
    
    select 
        @CurParamVal    = ParamValue , 
        @CurParamDflt   = DefaultValue,
        @NullableValue  = ValueCanBeNULL,
        @Depreciated    = isDepreciated
    FROM 
        [Common].[ApplicationParams]
    WHERE 
        ApplicationName = @ApplicationName
    AND ParamName       = @ParamName ;
    
    -- Check we got a parameter.
    
    IF(@Depreciated IS NULL or @NullableValue IS NULL)
    BEGIN 
        RAISERROR('Parameter "%s" for application "%s" does not exist !',12,1,@ParamName,@ApplicationName);
    END ;   
    
    IF(@Depreciated = 1)
    BEGIN 
        -- display warning 
        RAISERROR('Parameter "%s" for application "%s" is depreciated',1,1,@ParamName,@ApplicationName);
    END ;
    
    -- Get back parameter value
    DECLARE @ValueAssignmentHappened BIT;
    SET @ValueAssignmentHappened = 0;
    IF(@CurParamVal IS NOT NULL)
	BEGIN
        SET @ParamValue = @CurParamVal ;
        SET @ValueAssignmentHappened = 1;
    END; 
    
    IF(@CurParamVal IS NULL and @NullableValue = 0 AND @CurParamDflt IS NOT NULL)
    BEGIN 
        SET @ParamValue = @CurParamDflt ;
        SET @ValueAssignmentHappened = 1;
    END;
    
    IF(@CurParamVal IS NULL AND @NullableValue = 1)
    BEGIN 
        SET @ParamValue = @CurParamVal ;
        SET @ValueAssignmentHappened = 1;
    END;
    IF(@ValueAssignmentHappened = 0)
    BEGIN
        RAISERROR('Invalid parameter settings for Application "%s" - Parameter "%s"',12,1,@ApplicationName,@ParamName);
    END ;
    
END ;
GO

IF @@ERROR = 0
    PRINT '   Procedure altered.';
ELSE
BEGIN
    PRINT '   Error while trying to modify procedure';
    RETURN;
END;
GO

PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT '' ;
GO
    