
/* ======================================================================================================================
TEST SETUP
*/

USE [TestDb];
GO

IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'RoleToBeDropped' AND type = 'R')
	CREATE ROLE [RoleToBeDropped];
GO

IF NOT EXISTS (SELECT * FROM sys.schemas WHERE name = N'ApplicationSchema1')
	EXEC sys.sp_executesql N'CREATE SCHEMA [ApplicationSchema1] AUTHORIZATION [RoleToBeDropped];'
ELSE
    EXEC sys.sp_executesql N'ALTER AUTHORIZATION  ON SCHEMA::[ApplicationSchema1] TO [RoleToBeDropped];'
GO  

IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'RoleA' AND type = 'R')
	CREATE ROLE [RoleA] AUTHORIZATION [RoleToBeDropped];
ELSE
   EXEC sys.sp_executesql N'ALTER AUTHORIZATION  ON ROLE::[RoleA] TO [RoleToBeDropped];'
GO

IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'ApplicationSQLUser1')
	CREATE USER [ApplicationSQLUser1] WITHOUT LOGIN WITH DEFAULT_SCHEMA=[dbo];
GO

IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'UserB')
	CREATE USER [UserB] WITHOUT LOGIN WITH DEFAULT_SCHEMA=[dbo];
GO

ALTER ROLE [RoleToBeDropped] ADD MEMBER [ApplicationSQLUser1]
GO

GRANT CONNECT TO [RoleToBeDropped] WITH GRANT OPTION  AS [dbo];
GO

GRANT CONNECT TO [RoleToBeDropped] WITH GRANT OPTION  AS [dbo];
GO

GRANT ALTER ON DATABASE::[TestDb] TO [RoleToBeDropped] WITH GRANT OPTION  AS [dbo];
GO

/*
    Create stored procedure referencing ApplicationSQLUser1 in TestDb
*/

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ApplicationSchema1].[sp_ExecuteAsRole2BD]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [ApplicationSchema1].[sp_ExecuteAsRole2BD] AS SELECT 1'
END
GO

ALTER PROCEDURE [ApplicationSchema1].[sp_ExecuteAsRole2BD]
WITH EXECUTE AS 'ApplicationSQLUser1'
AS
BEGIN
	SELECT @@SERVERNAME
END;

GO

grant execute on OBJECT::[ApplicationSchema1].[sp_ExecuteAsRole2BD] to UserB AS RoleToBeDropped;
GO