
/* ======================================================================================================================
    Cleanups
*/


USE [TestDb];
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ApplicationSchema1].[sp_ExecuteAsRole2BD]') AND type in (N'P', N'PC'))
    EXEC sp_executesql N'DROP PROCEDURE [ApplicationSchema1].[sp_ExecuteAsRole2BD]';
    

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = N'RoleToBeDropped' AND type = 'R')
BEGIN
    EXEC sp_executesql N'REVOKE ALTER ON DATABASE::[TestDb] FROM [RoleToBeDropped] CASCADE';
    EXEC sp_executesql N'REVOKE CONNECT FROM [RoleToBeDropped] CASCADE';    
    
    IF EXISTS (SELECT * FROM sys.database_principals WHERE name = N'ApplicationSQLUser1')
        EXEC sp_executesql N'ALTER ROLE [RoleToBeDropped] DROP MEMBER [ApplicationSQLUser1]';
        
    EXEC sp_executesql N'DROP ROLE [RoleToBeDropped]';
END;

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = N'UserB')
	EXEC sp_executesql N'DROP USER [UserB]';
GO

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = N'RoleA' AND type = 'R')
	EXEC sp_executesql N'DROP ROLE [RoleA]';

IF EXISTS (SELECT * FROM sys.schemas WHERE name = N'ApplicationSchema1')
    EXEC sp_executesql N'DROP SCHEMA ApplicationSchema1';
    