-- Test should fail (reason why setting @ExecRet to 0 in CATCH section)
-- Reason: no database permissions preservation

DECLARE @ExecRet INT;
DECLARE @LogMsg VARCHAR(MAX);
DECLARE @LineFeed CHAR(2) = CHAR(13) + CHAR(10);

BEGIN TRY
    EXEC @ExecRet = [Administration].[DropDatabasePrincipal]
				@DatabaseName						= 'TestDb',
				@PrincipalName						= 'RoleToBeDropped',
                @PreserveAssignedPermissions        = 0, -- defaults to 1
				@AssignRolePermissionsToItsMembers	= 1,
				@AlterDbObjectsOwnership			= 1,
				@NewDbObjectOwner					= 'dbo',
				@RunCheckOnly                       = 0,
				@Debug								= 0
		;
    
    IF(@ExecRet = 0)
    BEGIN
        SET @ExecRet = 1;
    END;
END TRY
BEGIN CATCH
    DECLARE @ErrorMessage   NVARCHAR(4000)  = ERROR_MESSAGE();
    
    IF(@ErrorMessage LIKE 'Permissions are assigned by database principal [RoleToBeDropped]%')
    BEGIN 
        SET @ExecRet = 0;
    END;
    ELSE
    BEGIN
        DECLARE @ErrorNumber    INT             = ERROR_NUMBER();
        DECLARE @ErrorLine      INT             = ERROR_LINE();
        DECLARE @ErrorSeverity  INT             = ERROR_SEVERITY();
        DECLARE @ErrorState     INT             = ERROR_STATE();    
        SET @LogMsg = 'Caught error #' + CAST(@ErrorNumber AS VARCHAR(10)) + /*'during XXX' + */ @LineFeed +
                      'At line #' + CAST(@ErrorLine AS VARCHAR(10)) + @LineFeed +
                      'With Severity ' + CAST(@ErrorSeverity AS VARCHAR(10)) + ' State ' + CAST(@ErrorState AS VARCHAR(10)) + @LineFeed +
                      @LineFeed +
                      'Message:' + @LineFeed +
                      '-------' + @LineFeed +
                      @ErrorMessage 
                      ;
                      
        RAISERROR(@LogMsg,0,1);
        SET @ExecRet = 1;
    END;
END CATCH 

IF(@ExecRet = 1)
BEGIN
    RAISERROR('Test failed',12,1);
END;
ELSE
BEGIN
    RAISERROR('Test successful',0,1);
END;
GO

