

USE [msdb]
GO

DECLARE @jobid AS UNIQUEIDENTIFIER
SELECT @jobid = job_id FROM msdb.dbo.sysjobs WHERE name = 'Sync-SqlInstanceObjects'
IF @jobid IS NOT NULL
BEGIN
	EXEC msdb.dbo.sp_delete_job @job_id = @jobid	 
END
GO

BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0

IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Database Maintenance' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Database Maintenance'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Sync-SqlInstanceObjects', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Synchronizes the below listed server objects between all Availability Group replicas.

Login
BackupDevice
Endpoint
LinkedServer
AgentCategory
SharedSchedule
Operator
Credential
ProxyAccount
Job', 
		@category_name=N'Database Maintenance', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Call Sync-SqlInstanceObjects.ps1', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'CmdExec', 
		@command=N'cmd /c net use M: \\mystorageaccountname.file.core.windows.net\maintenancescripts "WQblqxDeyorCdof1I+PfakeprimarykeyFDWVVdo6NENQnof4/2AfkSSjGiTmZ5XtMsQ==" /user:Azure\mystorageaccountname && C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe "& M:\Sync-SqlInstanceObjects.ps1 -DomainName ''mydomain.com'' -Port 1433;" && net use M: /delete /Y', 
		@flags=32, 
		@proxy_name=N'DOMAIN\service_account_name'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Daily', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=1, 
		@freq_subday_interval=0, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20170803, 
		@active_end_date=99991231, 
		@active_start_time=90000, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO


