﻿
#----------------------------------------
# Author: 	Craig Porteous
# Date:		13/03/2017
#
#----------------------------------------
# Prerequisites
# > Install-Module -Name MSOnline
#
#----------------------------------------
#Working folder
$folder = "D:\Dropbox\CraigPorteous.com\SQL User Group\Presentations\PowerShell_in_PowerBI\"
#Password prep
$file = $folder + "cporteous_cred.txt"
#Read-Host -Prompt "Please enter Password for cporteous" -AsSecureString | ConvertFrom-SecureString | Out-File $file
#----------------------------------------
cls
$adminName = "cporteous@sqlglasgow.co.uk"
$Pass = Get-Content $file | ConvertTo-SecureString
$Cred = new-object -typename System.Management.Automation.PSCredential -argumentlist $AdminName, $Pass
#----------------------------------------

#Connect to Azure
Connect-MsolService -Credential $cred

#Lets see tenant license summary (all licensing)
Get-MsolAccountSku

#Lets see this for each user
#-------------------------------------------------------------------------------
$PBIUsers = Get-MsolUser -All | ?{$_.isLicensed-eq "TRUE" -and ($_.Licenses | ?{$_.AccountSkuId -like '*POWER_BI_PRO*' -or $_.AccountSkuId -like '*POWER_BI_STANDARD*'}).Length -gt 0} | Select DisplayName, SignInName, @{n="Licenses Type";e={$_.Licenses.AccountSKUid}}

$PBIUsers | Export-CSV ($folder + "PowerBILicenses.csv") -NoTypeInformation
$PBIUsers
#-------------------------------------------------------------------------------



