﻿
#----------------------------------------
# Author: 	Craig Porteous
# Date:		13/03/2017
#
#----------------------------------------
# Prerequisites
# > Install-Module -Name AzureAD
#
#----------------------------------------
#Working folder
$folder = "C:\Dropbox\CraigPorteous.com\SQL User Group\Presentations\PowerShell_in_PowerBI\"
#Password prep
$file = $folder + "cporteous_cred.txt"
#Read-Host -Prompt "Please enter Password for cporteous" -AsSecureString | ConvertFrom-SecureString | Out-File $file
#----------------------------------------
cls
$adminName = "cporteous@sqlglasgow.co.uk"
$Pass = Get-Content $file | ConvertTo-SecureString
$Cred = new-object -typename System.Management.Automation.PSCredential -argumentlist $AdminName, $Pass
#----------------------------------------

#Connect to Azure
Connect-AzureAD -Credential $cred
#-------------------------------------------------------------------------------
#Collect license info
$PBILicenses = Get-AzureADSubscribedSku #| ?{$_.SkuPartNumber -like '*POWER_BI*' -and $_.CapabilityStatus -eq "Enabled"} | SELECT SkuPartNumber, ConsumedUnits, SkuId
#Return global license count
$PBILicenses | SELECT SkuPartNumber, ConsumedUnits, @{n="ActiveUnits";e={$_.PrepaidUnits.Enabled}}

#Lets see it for each user
#-------------------------------------------------------------------------------
#Loop through each license and list all users
foreach($license in $PBILicenses)
{
    $PBIUsers = Get-AzureADUser -All 1 | ?{($_.AssignedLicenses | ?{$_.SkuId -eq $license.SkuId})} | SELECT DisplayName, UserPrincipalName, @{l="License";e={$license.SkuPartNumber}} 
}

$PBIUsers | Export-CSV ($folder + "PowerBILicenses.csv") -NoTypeInformation
$PBIUsers
#-------------------------------------------------------------------------------



