#----------------------------------------
# Author: 	Craig Porteous
# Date:		11/08/2017
#  Connection to Power BI REST API.
#----------------------------------------
# Prerequisites
# > Install-Module -Name Microsoft.ADAL.PowerShell
#
#----------------------------------------
#Working folder
$folder = "D:\Dropbox\CraigPorteous.com\SQL User Group\Presentations\PowerShell_in_PowerBI\"
#Password prep
$file = $folder + "cporteous_cred.txt"
#Read-Host -Prompt "Please enter Password for cporteous" -AsSecureString | ConvertFrom-SecureString | Out-File $file
#
#----------------------------------------
# Load Active Directory Authentication Library (ADAL) Assemblies
#$adal = "${env:ProgramFiles(x86)}\Microsoft SDKs\Azure\PowerShell\ServiceManagement\Azure\Services\Microsoft.IdentityModel.Clients.ActiveDirectory.dll"
#$adalforms = "${env:ProgramFiles(x86)}\Microsoft SDKs\Azure\PowerShell\ServiceManagement\Azure\Services\Microsoft.IdentityModel.Clients.ActiveDirectory.WindowsForms.dll"
#Alternate folder location
$adal = "${env:ProgramFiles}\WindowsPowerShell\Modules\Microsoft.ADAL.PowerShell\1.12\Microsoft.IdentityModel.Clients.ActiveDirectory.dll"
$adalforms = "${env:ProgramFiles}\WindowsPowerShell\Modules\Microsoft.ADAL.PowerShell\1.12\Microsoft.IdentityModel.Clients.ActiveDirectory.WindowsForms.dll"

[System.Reflection.Assembly]::LoadFrom($adal)
[System.Reflection.Assembly]::LoadFrom($adalforms)
#----------------------------------------
# To find your Office 365 tenant ID in the Azure AD portal
# - Log in to Microsoft Azure as an administrator.
# - In the Microsoft Azure portal, click Azure Active Directory.
# - Under Manage, click Properties. The tenant ID is shown in the Directory ID box.
$tenantID = "fb57d3b7-8251-4b90-9888-b20295ccca11"
$pbiAuthorityUrl = "https://login.windows.net/$tenantID/oauth2/token"
$pbiResourceUrl = "https://analysis.windows.net/powerbi/api"
#----------------------------------------
# Client ID & Client Secret 
$clientId = "ac8c31af-ffda-4f81-870d-602ed03332f2"
$client_secret = "DrMcfCLNqXZFWDZPnl4fOCq3Xz3/jAO8QaH38AvMZVg="

$adminName = "cporteous@sqlglasgow.co.uk"
#Retrieve password from secure string file
$Pass = Get-Content $file | ConvertTo-SecureString
#Convert back to plain text
$BSTR = [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($Pass)
$UnsecurePassword = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)

# Authenticate to Azure/PBI-------------------------------------

    $authBody = @{
        'resource'=$pbiResourceUrl
        'client_id'=$clientId        
        'grant_type'="password"
        'username'=$adminName
        'password'= $UnsecurePassword
        'scope'="openid"
        'client_secret'=$client_secret
    }

    #NOTE: First use of an "App" needs to be granted permission like in the interactive login method!! 
    # or granted from Azure Portal (-> go to Azure Active Directory -> App Registrations -> find your app -> Required Permissions -> Grant Permissions.)

#Auth to API to get Token
$auth = Invoke-RestMethod -Uri $pbiAuthorityUrl -Body $authBody -Method POST -Verbose
#Clear password variable
$UnsecurePassword = ''
#-----------------------------------------------------------
# Building Rest API header with authorization token
$authHeader = @{
    'Content-Type'='application/json'
    'Authorization'='Bearer ' + $auth.access_token
    }
#Lets get all Groups
$uri = "https://api.powerbi.com/v1.0/myorg/groups"
$groups = Invoke-RestMethod -Uri $uri -Headers $authHeader -Method GET -Verbose

#Declare final Array
$PBIDatasets = @()
#Loop through Group info & add to new array
foreach($group in $groups.value)
{
    $groupID = $group.id
        
    $uri = "https://api.powerbi.com/v1.0/myorg/groups/$groupID/datasets"
    $datasets = Invoke-RestMethod -Uri $uri -Headers $authHeader -Method GET -Verbose

    foreach($dataset in $datasets.value)
    {
        $datasetID = $dataset.id
        $uri2 = "https://api.powerbi.com/v1.0/myorg/groups/$groupID/datasets/$datasetID/refreshes"
        $refreshes = Invoke-RestMethod -Uri $uri2 -Headers $authHeader -Method GET -Verbose
        
        $PBIDatasets += New-Object PsObject -Property @{
            "GroupName"="$($group.name)";
            "GroupID"="$($group.id)";
            "DatasetName"="$($dataset.name)";
            "DatasetID"="$($dataset.id)";
            "DatasetOwner"="$($dataset.configuredBy)";
            "LastRefreshType"="$($refreshes.value[0].refreshType)";
            "LastRefreshStart"="$($refreshes.value[0].startTime)";
            "LastRefreshEnd"="$($refreshes.value[0].endTime)";
            "LastRefreshStatus"="$($refreshes.value[0].status)";
	    }
    }
    $datasets = $null
}
$PBIDatasets