#----------------------------------------
# Author: 	Craig Porteous
# Date:		16/08/2017
#
#----------------------------------------
# Prerequisites
# > Install-Module -Name Microsoft.ADAL.PowerShell
#
#----------------------------------------
# AAD Client ID
# To get this, go to the following page and follow the steps to provision an app
# https://dev.powerbi.com/apps
# To get the sample to work, ensure that you have the following fields:
# App Type: Native app
# Redirect URL: urn:ietf:wg:oauth:2.0:oob
# Level of access: all dataset APIs

# ClientID from App created under sqlglasgow.co.uk domain
$clientId = "8261e06b-fe89-4099-9faf-f85a700617c6" 

# End Parameters =======================================

# Calls the Active Directory Authentication Library (ADAL) to authenticate against AAD
function GetAuthToken
{
       #$adal = "${env:ProgramFiles(x86)}\Microsoft SDKs\Azure\PowerShell\ServiceManagement\Azure\Services\Microsoft.IdentityModel.Clients.ActiveDirectory.dll"
       #$adalforms = "${env:ProgramFiles(x86)}\Microsoft SDKs\Azure\PowerShell\ServiceManagement\Azure\Services\Microsoft.IdentityModel.Clients.ActiveDirectory.WindowsForms.dll"
       #Alternate folder location
       $adal = "${env:ProgramFiles}\WindowsPowerShell\Modules\Microsoft.ADAL.PowerShell\1.12\Microsoft.IdentityModel.Clients.ActiveDirectory.dll"
       $adalforms = "${env:ProgramFiles}\WindowsPowerShell\Modules\Microsoft.ADAL.PowerShell\1.12\Microsoft.IdentityModel.Clients.ActiveDirectory.WindowsForms.dll"

       [System.Reflection.Assembly]::LoadFrom($adal) | Out-Null
       [System.Reflection.Assembly]::LoadFrom($adalforms) | Out-Null
 
       $redirectUri = "urn:ietf:wg:oauth:2.0:oob"
 
       $resourceAppIdURI = "https://analysis.windows.net/powerbi/api"
 
       $authority = "https://login.windows.net/common/oauth2/authorize";
 
       $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext" -ArgumentList $authority
 
       $authResult = $authContext.AcquireToken($resourceAppIdURI, $clientId, $redirectUri, "Auto")
 
       return $authResult
}

# Get the auth token from AAD
$token = GetAuthToken

# Building Rest API header with authorization token
$authHeader = @{
   'Content-Type'='application/json'
   'Authorization'=$token.CreateAuthorizationHeader()
}

#Lets get all Groups
$uri = "https://api.powerbi.com/v1.0/myorg/groups"
$groups = Invoke-RestMethod -Uri $uri -Headers $authHeader -Method GET -Verbose
#$groups.value

#Declare final Array
$PBIDatasets = @()
#Loop through Group info & add to new array

foreach($group in $groups.value)
{
    $groupID = $group.id
        
    $uri = "https://api.powerbi.com/v1.0/myorg/groups/$groupID/datasets"
    $datasets = Invoke-RestMethod -Uri $uri -Headers $authHeader -Method GET -Verbose

    foreach($dataset in $datasets.value)
    {
        $datasetID = $dataset.id
        $uri2 = "https://api.powerbi.com/v1.0/myorg/groups/$groupID/datasets/$datasetID/refreshes"
        $refreshes = Invoke-RestMethod -Uri $uri2 -Headers $authHeader -Method GET -Verbose
        
        $PBIDatasets += New-Object PsObject -Property @{
            "GroupName"="$($group.name)";
            "GroupID"="$($group.id)";
            "DatasetName"="$($dataset.name)";
            "DatasetID"="$($dataset.id)";
            "DatasetOwner"="$($dataset.configuredBy)";
            "LastRefreshType"="$($refreshes.value[0].refreshType)";
            "LastRefreshStart"="$($refreshes.value[0].startTime)";
            "LastRefreshEnd"="$($refreshes.value[0].endTime)";
            "LastRefreshStatus"="$($refreshes.value[0].status)";
	    }
    }

    $datasets = $null

}

$PBIDatasets 

# Refresh the dataset
# $uri = "https://api.powerbi.com/v1.0/$groupsPath/datasets/$datasetID/refreshes"
# Invoke-RestMethod -Uri $uri -Headers $authHeader -Method POST -Verbose