
-- Test should succeed
-- With reassign of role permissions towards its members

DECLARE @ExecRet        INT;
DECLARE @LogMsg         VARCHAR(MAX);
DECLARE @LineFeed       CHAR(2) = CHAR(13) + CHAR(10);
DECLARE @tsql           NVARCHAR(MAX);
DECLARE @tmpINT         INT;

BEGIN TRY
    EXEC @ExecRet = [Administration].[DropDatabasePrincipal]
				@DatabaseName						= 'TestDb',
				@PrincipalName						= 'RoleToBeDropped',
				@AssignRolePermissionsToItsMembers	= 1,
				@AlterDbObjectsOwnership			= 1,
				@NewDbObjectOwner					= 'dbo',
				@RunCheckOnly                       = 0,
				@Debug								= 0
		;
    
    IF(@ExecRet <> 0)
    BEGIN
        RAISERROR('An untrapped error occurred',12,1);
    END;
    
    /*
        Check results:
    */
    
    -- is the role actually dropped?
    SET @tsql = 'USE [TestDb];' + @LineFeed +
                'SELECT @rtval = CASE WHEN (USER_ID(''RoleToBeDropped'') IS NULL) THEN 1 ELSE 0 END;' 
                ;
    
    EXEC sp_executesql @tsql, N'@rtval INT OUTPUT', @rtval = @tmpINT OUTPUT;
    
    IF(@tmpINT = 0)
    BEGIN
        RAISERROR('Role still exists',0,1);
        SET @ExecRet = 1;
    END;
    
    -- is ApplicationSchema1 owned by dbo ?
    SET @tsql = 'USE [TestDb];' + @LineFeed +
                'SELECT @rtval = COUNT(*) FROM sys.schemas WHERE [name] = ''ApplicationSchema1'' and principal_id = USER_ID(''dbo'');' 
                ;
                
    EXEC sp_executesql @tsql, N'@rtval INT OUTPUT', @rtval = @tmpINT OUTPUT;
    
    IF(@tmpINT = 0)
    BEGIN
        RAISERROR('ApplicationSchema1 not owned by dbo',0,1);
        SET @ExecRet = 1;
    END;
    
    -- is RoleA owned by dbo ?
    SET @tsql = 'USE [TestDb];' + @LineFeed +
                'SELECT @rtval = COUNT(*) FROM sys.database_principals where name = ''RoleA'' and owning_principal_id = USER_ID(''dbo'');' 
                ;
                
    EXEC sp_executesql @tsql, N'@rtval INT OUTPUT', @rtval = @tmpINT OUTPUT;
    
    IF(@tmpINT = 0)
    BEGIN
        RAISERROR('RoleA not owned by dbo',0,1);
        SET @ExecRet = 1;
    END;    
    
    -- is UserB granted EXECUTE permission on ApplicationSchema1.sp_ExecuteAsRole2BD
    SET @tsql = 'USE [TestDb];' + @LineFeed +
                'SELECT @rtval = COUNT(*)' + @LineFeed +
                'FROM sys.database_permissions ' + @LineFeed + 
                'where major_id             = OBJECT_ID(''ApplicationSchema1.sp_ExecuteAsRole2BD'') ' + @LineFeed + 
                'and grantee_principal_id   = USER_ID(''UserB'') ' + @LineFeed + 
                'and permission_name        = ''EXECUTE'' ' + @LineFeed + 
                'and state_desc             = ''GRANT''' + @LineFeed + 
                ';' 
                ;
                
    EXEC sp_executesql @tsql, N'@rtval INT OUTPUT', @rtval = @tmpINT OUTPUT;
    
    IF(@tmpINT = 0)
    BEGIN
        RAISERROR('UserB should be granted EXECUTE permission on ApplicationSchema1.sp_ExecuteAsRole2BD',0,1);
        SET @ExecRet = 1;
    END; 
    
    -- Does ApplicationSQLUser1 have the CONNECT WITH GRANT OPTION permission? (should not)
    SET @tsql = 'USE [TestDb];' + @LineFeed +
                'SELECT @rtval = COUNT(*)' + @LineFeed +
                'FROM sys.database_permissions ' + @LineFeed + 
                'where major_id             = 0' + @LineFeed + 
                'and grantee_principal_id   = USER_ID(''ApplicationSQLUser1'') ' + @LineFeed + 
                'and permission_name        = ''CONNECT'' ' + @LineFeed + 
                'and state_desc             = ''GRANT_WITH_GRANT_OPTION''' + @LineFeed + 
                ';' 
                ;
                
    EXEC sp_executesql @tsql, N'@rtval INT OUTPUT', @rtval = @tmpINT OUTPUT;
    
    IF(@tmpINT = 0)
    BEGIN
        RAISERROR('ApplicationSQLUser1 should have been granted the CONNECT WITH GRANT OPTION permission',0,1);
        SET @ExecRet = 1;
    END; 
    
END TRY
BEGIN CATCH
    DECLARE @ErrorMessage   NVARCHAR(4000)  = ERROR_MESSAGE();

    DECLARE @ErrorNumber    INT             = ERROR_NUMBER();
    DECLARE @ErrorLine      INT             = ERROR_LINE();
    DECLARE @ErrorSeverity  INT             = ERROR_SEVERITY();
    DECLARE @ErrorState     INT             = ERROR_STATE();    
    
    SET @LogMsg = 'Caught error #' + CAST(@ErrorNumber AS VARCHAR(10)) + /*'during XXX' + */ @LineFeed +
                  'At line #' + CAST(@ErrorLine AS VARCHAR(10)) + @LineFeed +
                  'With Severity ' + CAST(@ErrorSeverity AS VARCHAR(10)) + ' State ' + CAST(@ErrorState AS VARCHAR(10)) + @LineFeed +
                  @LineFeed +
                  'Message:' + @LineFeed +
                  '-------' + @LineFeed +
                  @ErrorMessage 
                  ;
                  
    RAISERROR(@LogMsg,0,1);
    SET @ExecRet = 1;
END CATCH 

IF(@ExecRet = 1)
BEGIN
    RAISERROR('Test failed',12,1);
END;
ELSE
BEGIN
    RAISERROR('Test successful',0,1);
END;
GO
