/*requires Schema.Docs.sql*/
/*requires Table.Docs.SchemaObjectDictionary.sql*/
/*requires Table.Docs.SchemaObjectsAttributes.sql*/

PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT 'VIEW [Docs].[SchemaObjectsAttributesDetails]';

DECLARE @ViewSchema SYSNAME;
DECLARE @ViewName   SYSNAME;

SET @ViewSchema = 'Docs';
SET @ViewName   = 'SchemaObjectsAttributesDetails';

IF  NOT EXISTS (SELECT 1 FROM sys.views WHERE object_id = OBJECT_ID(QUOTENAME(@ViewSchema) + '.' + QUOTENAME(@ViewName)))
BEGIN 
    DECLARE @tsql NVARCHAR(MAX) ;
    DECLARE @LineFeed VARCHAR(8);
    SET @LineFeed = CHAR(13) + CHAR(10);
    
    SET @tsql = 'CREATE VIEW ' + QUOTENAME(@ViewSchema) + '.' + QUOTENAME(@ViewName) + @LineFeed +
                'AS ' + @LineFeed +
                '    SELECT ''Not implemented'' as Col1' + @LineFeed;
      
    exec sp_executesql @tsql ;
    
	IF @@ERROR = 0
        PRINT '   VIEW created.';
    ELSE
    BEGIN
        PRINT '   Error while trying to create view';
        RETURN
    END ;    
END 
GO



ALTER VIEW [Docs].[SchemaObjectsAttributesDetails]
AS
    select 
        od.DatabaseName, 
        od.SchemaName,
        od.ObjectName,
        coa.AttributeName,
        coa.HasBeenDeleted as DeletedAttribute,
        od.ObjectType,
        od.isDepreciated as ObjectIsDepreciated,
        od.ObjectDescription,
        coa.AttributeDescription,
        od.DefinitionId as ObjectDefinitionId,
        coa.DefinitionId as ColumnDefinitionId
    From Docs.SchemaObjectDictionary od 
    inner join Docs.SchemaObjectsAttributes coa
    on od.DefinitionId = coa.ObjectDictionaryId
;
GO

IF @@ERROR = 0
    PRINT '   VIEW altered.';
ELSE
BEGIN
    PRINT '   Error while trying to alter VIEW';
    RETURN;
END   ;
GO

PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT '' ;

GO