/*requires Schema.Docs.sql*/
/*requires Table.Docs.SchemaObjectDictionary.sql*/
/*requires Table.Docs.SchemaObjectsAttributes.sql*/

PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT 'VIEW [Docs].[SchemaObjectDictionaryMissingDescription]';

DECLARE @ViewSchema SYSNAME;
DECLARE @ViewName   SYSNAME;

SET @ViewSchema = 'Docs';
SET @ViewName   = 'SchemaObjectDictionaryMissingDescription';

IF  NOT EXISTS (SELECT 1 FROM sys.views WHERE object_id = OBJECT_ID(QUOTENAME(@ViewSchema) + '.' + QUOTENAME(@ViewName)))
BEGIN
    DECLARE @tsql NVARCHAR(MAX) ;
    DECLARE @LineFeed VARCHAR(8);
    SET @LineFeed = CHAR(13) + CHAR(10);

    SET @tsql = 'CREATE VIEW ' + QUOTENAME(@ViewSchema) + '.' + QUOTENAME(@ViewName) + @LineFeed +
                'AS ' + @LineFeed +
                '    SELECT ''Not implemented'' as Col1' + @LineFeed;

    exec sp_executesql @tsql ;

	IF @@ERROR = 0
        PRINT '   VIEW created.';
    ELSE
    BEGIN
        PRINT '   Error while trying to create view';
        RETURN
    END ;
END
GO



ALTER VIEW [Docs].[SchemaObjectDictionaryMissingDescription]
AS
    WITH DependentCounts
    AS (
        select ObjectDictionaryId, COUNT(*) as NbObj
        from Docs.SchemaObjectsAttributes
        where AttributeDescription IS NULL
        group by ObjectDictionaryId
    ),
    ObjectDescs
    AS (
        select
            sod.DefinitionId,
            sod.ServerId,
            sod.DatabaseName,
            sod.SchemaName,
            sod.ObjectName,
            sod.ObjectType,
            sod.ObjectDescription,
            sod.RelatedApplicationName,
            sod.RelatedModuleName,
            sod.isDepreciated,
            sod.hasBeenDeleted,
            sod.DeletionDiscoveryDate,
            sod.DeletionVersionFrom,
            sod.ReplacementObjectId,
            CASE WHEN ObjectDescription IS NULL THEN 1 ELSE 0 END as MissingDescription,
            isnull(dc.NbObj,0) as DependentMissingDescriptionCount
        from Docs.SchemaObjectDictionary sod
        left join DependentCounts dc
        on sod.DefinitionId = dc.ObjectDictionaryId
    )
    select
        DefinitionId,
        ServerId,
        DatabaseName,
        SchemaName,
        ObjectName,
        MissingDescription,
        DependentMissingDescriptionCount,
        'EXEC [Docs].[SchemaObjectDictionary_Upsert]' + CHAR(13)+CHAR(10) +
        '                 @DefinitionId           = ' + CONVERT(VARCHAR(10),DefinitionId) + ',' + CHAR(13)+CHAR(10) +
        '                 @ServerId               = ' + CASE WHEN ServerId IS NULL THEN 'NULL' ELSE CONVERT(VARCHAR(10),ServerId) END + ',' + CHAR(13)+CHAR(10)+
        '                 @DatabaseName           = ''' + DatabaseName + ''',' + CHAR(13)+CHAR(10)+
        '                 @SchemaName             = ''' + SchemaName + ''',' + CHAR(13)+CHAR(10)+
        '                 @ObjectName             = ''' + ObjectName + ''',' + CHAR(13)+CHAR(10)+
        '                 @ObjectType             = ''' + ObjectType + ''',' + CHAR(13)+CHAR(10)+
        '                 @ObjectDescription      = ''' + CASE WHEN ObjectDescription IS NULL THEN 'TODO:YOUR_DESCRIPTION' ELSE ObjectDescription END + ''',' + CHAR(13)+CHAR(10)+
        '                 @RelatedApplicationName = ' + CASE WHEN RelatedApplicationName IS NULL THEN 'NULL' ELSE '''' + RelatedApplicationName + '''' END + ',' + CHAR(13)+CHAR(10)+
        '                 @RelatedModuleName      = ' + CASE WHEN RelatedModuleName IS NULL THEN 'NULL' ELSE '''' + RelatedModuleName + '''' END + ',' + CHAR(13)+CHAR(10)+
        '                 @isDepreciated          = ' + CONVERT(CHAR(1),isDepreciated) + ',' +  CHAR(13)+CHAR(10)+
        '                 @hasBeenDeleted         = ' + CONVERT(CHAR(1),hasBeenDeleted) + ',' +  CHAR(13)+CHAR(10)+
        '                 @DeletionDiscoveryDate  = ' + CASE WHEN DeletionDiscoveryDate IS NULL THEN 'NULL' ELSE '''' + CONVERT(VARCHAR(16),DeletionDiscoveryDate,112) + '''' END + ',' +  CHAR(13)+CHAR(10)+
        '                 @DeletionVersionFrom    = ' + CASE WHEN DeletionVersionFrom IS NULL THEN 'NULL' ELSE '''' + DeletionVersionFrom + '''' END + ',' +  CHAR(13)+CHAR(10)+
        '                 @ReplacementObjectId    = ' + CASE WHEN ReplacementObjectId IS NULL THEN 'NULL' ELSE CONVERT(VARCHAR(10),ReplacementObjectId) END + CHAR(13)+CHAR(10) +
        ';' as DDL2UpdateDescription,
        'EXEC [Docs].[GetRelatedObjectDescriptions]' + CHAR(13)+CHAR(10) +
        '                 @ServerId               = ' + CASE WHEN ServerId IS NULL THEN 'NULL' ELSE CONVERT(VARCHAR(10),ServerId) END + ',' + CHAR(13)+CHAR(10) +
        '                 @DatabaseName           = ''' + DatabaseName + ''',' + CHAR(13)+CHAR(10)+
        '                 @SchemaName             = ''' + SchemaName + ''',' + CHAR(13)+CHAR(10)+
        '                 @ObjectName             = ''' + ObjectName + '''' + CHAR(13)+CHAR(10)+
        ';' as DDL2GetDependentDescription
    FROM ObjectDescs
    WHERE MissingDescription = 1
    OR DependentMissingDescriptionCount > 0
;
GO

IF @@ERROR = 0
    PRINT '   VIEW altered.';
ELSE
BEGIN
    PRINT '   Error while trying to alter VIEW';
    RETURN;
END   ;
GO

PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT '' ;

GO