/*requires Schema.Docs.sql*/
/*requires Table.Docs.SchemaObjectDictionary.sql*/

PRINT '--------------------------------------------------------------------------------------------------------------'
PRINT 'Table [Docs].[SchemaObjectsAttributes] Creation'
GO

IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes]') AND type in (N'U'))
BEGIN
    CREATE TABLE [Docs].[SchemaObjectsAttributes] (
        DefinitionId            BIGINT          IDENTITY(1,1) NOT NULL,
        ObjectDictionaryId      BIGINT          NOT NULL,
        AttributeName           VARCHAR(256)    NOT NULL,
        AttributeDescription    VARCHAR(4000)   NULL,
        HasBeenDeleted          BIT             NOT NULL,
        DeletionDiscoveryDate   DATE            NULL,
        DeletionVersionFrom     VARCHAR(64)     NULL,
        ReplacementDefinitionId BIGINT          NULL
    ) ON [PRIMARY]

    PRINT '    Table [Docs].[SchemaObjectsAttributes] created.'
END
ELSE
BEGIN
    PRINT '    Table [Docs].[SchemaObjectsAttributes] already exists.'
END
GO



IF  NOT EXISTS (SELECT 1 FROM sys.indexes WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes]') AND name = N'IX_SchemaObjectsAttributes')
BEGIN 
    CREATE UNIQUE CLUSTERED INDEX [IX_SchemaObjectsAttributes] ON [Docs].[SchemaObjectsAttributes] (
        ObjectDictionaryId, AttributeName
    );
    
    PRINT '    Clustered index created.';
END;
GO



IF  NOT EXISTS (SELECT 1 FROM sys.indexes WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes]') AND name = N'PK_SchemaObjectsAttributes')
BEGIN 
    ALTER TABLE [Docs].[SchemaObjectsAttributes] ADD  CONSTRAINT [PK_SchemaObjectsAttributes] PRIMARY KEY NONCLUSTERED (
        DefinitionId
    );
    
    PRINT '    Primary Key created.';
    
END;
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[Docs].[FK_SchemaObjectsAttributes_ObjectDictionaryId]') AND parent_object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes]'))
BEGIN
    ALTER TABLE [Docs].[SchemaObjectsAttributes]
        ADD  CONSTRAINT [FK_SchemaObjectsAttributes_ObjectDictionaryId]
            FOREIGN KEY (
                [ObjectDictionaryId]
            )
        REFERENCES [Docs].[SchemaObjectDictionary] ([DefinitionId])
    IF @@ERROR = 0
        PRINT '   Foreign Key [FK_SchemaObjectsAttributes_ObjectDictionaryId] created.'
    ELSE
    BEGIN
        PRINT '   Error while trying to create Foreign Key [FK_SchemaObjectsAttributes_ObjectDictionaryId]'
        RETURN
    END
END
GO


IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Docs].[DF_SchemaObjectsAttributes_HasBeenDeleted]') AND type = 'D')
BEGIN
    ALTER TABLE [Docs].[SchemaObjectsAttributes]
        ADD CONSTRAINT [DF_SchemaObjectsAttributes_HasBeenDeleted] DEFAULT (0) FOR [HasBeenDeleted]
	PRINT '   Constraint [DF_SchemaObjectsAttributes_HasBeenDeleted] created.';
END;
GO





PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT '';
GO

