/*requires Schema.Docs.sql*/

PRINT '--------------------------------------------------------------------------------------------------------------'
PRINT 'Table [Docs].[SchemaObjectDictionary] Creation'
GO

IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary]') AND type in (N'U'))
BEGIN
    CREATE TABLE [Docs].[SchemaObjectDictionary] (
        DefinitionId            BIGINT          IDENTITY(1,1) NOT NULL,
        ServerId                BIGINT          NULL,
        DatabaseName            VARCHAR(256)    NOT NULL,
        SchemaName              VARCHAR(256)    NOT NULL,
        ObjectName              VARCHAR(256)    NOT NULL,
        ObjectType              VARCHAR(256)    NOT NULL,
        ObjectDescription       VARCHAR(4000)   NULL,
        RelatedApplicationName  VARCHAR(256)    NULL,
        RelatedModuleName       VARCHAR(256)    NULL,
        isDepreciated           BIT             NOT NULL,
        hasBeenDeleted          BIT             NOT NULL,
        DeletionDiscoveryDate   DATE            NULL,
        DeletionVersionFrom     VARCHAR(64)     NULL,
        ReplacementObjectId     BIGINT          NULL
    ) ON [PRIMARY]

    PRINT '    Table [Docs].[SchemaObjectDictionary] created.'
END
ELSE
BEGIN
    PRINT '    Table [Docs].[SchemaObjectDictionary] already exists.'
END
GO



IF  NOT EXISTS (SELECT 1 FROM sys.indexes WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary]') AND name = N'IX_SchemaObjectDictionary')
BEGIN 
    CREATE UNIQUE CLUSTERED INDEX [IX_SchemaObjectDictionary] ON [Docs].[SchemaObjectDictionary] (
        ServerId,DatabaseName, SchemaName, ObjectName
    );
    
    PRINT '    Clustered index created.';
END;
GO



IF  NOT EXISTS (SELECT 1 FROM sys.indexes WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary]') AND name = N'PK_SchemaObjectDictionary')
BEGIN 
    ALTER TABLE [Docs].[SchemaObjectDictionary] ADD  CONSTRAINT [PK_SchemaObjectDictionary] PRIMARY KEY NONCLUSTERED (
        DefinitionId
    );
    
    PRINT '    Primary Key created.';
    
END;
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Docs].[DF_SchemaObjectDictionary_isDepreciated]') AND type = 'D')
BEGIN
    ALTER TABLE [Docs].[SchemaObjectDictionary]
        ADD CONSTRAINT [DF_SchemaObjectDictionary_isDepreciated] DEFAULT (0) FOR [isDepreciated]
	PRINT '   Constraint [DF_SchemaObjectDictionary_isDepreciated] created.';
END;
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Docs].[DF_SchemaObjectDictionary_hasBeenDeleted]') AND type = 'D')
BEGIN
    ALTER TABLE [Docs].[SchemaObjectDictionary]
        ADD CONSTRAINT [DF_SchemaObjectDictionary_hasBeenDeleted] DEFAULT (0) FOR [hasBeenDeleted]
	PRINT '   Constraint [DF_SchemaObjectDictionary_hasBeenDeleted] created.';
END;
GO





PRINT '--------------------------------------------------------------------------------------------------------------';
PRINT '';
GO

