

/****** Object:  StoredProcedure [Docs].[SchemaObjectsAttributes_Delete]    Script Date: 08-06-17 13:02:32 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes_Delete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectsAttributes_Delete](
    @DefinitionId as bigint
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Deletes a given record in [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] table
     *----------------------------------------------------------------------------------*/
BEGIN
    BEGIN TRY
        -- Delete
        DELETE [TestSchemaDoc].[Docs].[SchemaObjectsAttributes]
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO

-- =================


/****** Object:  StoredProcedure [Docs].[SchemaObjectsAttributes_Insert]    Script Date: 08-06-17 13:02:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes_Insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectsAttributes_Insert](
    @ObjectDictionaryId as bigint,
    @AttributeName as varchar(256),
    @AttributeDescription as varchar(4000) = NULL ,
    @HasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementDefinitionId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Inserts a record into [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- INSERT
        INSERT [TestSchemaDoc].[Docs].[SchemaObjectsAttributes](
            ObjectDictionaryId,
            AttributeName,
            AttributeDescription,
            HasBeenDeleted,
            DeletionDiscoveryDate,
            DeletionVersionFrom,
            ReplacementDefinitionId
        )
        VALUES (
            @ObjectDictionaryId,
            @AttributeName,
            @AttributeDescription,
            @HasBeenDeleted,
            @DeletionDiscoveryDate,
            @DeletionVersionFrom,
            @ReplacementDefinitionId
        );
        -- Return the new ID
        select SCOPE_IDENTITY();
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO


-- =================


/****** Object:  StoredProcedure [Docs].[SchemaObjectsAttributes_Select]    Script Date: 08-06-17 13:02:59 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes_Select]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectsAttributes_Select](
    @DefinitionId as bigint
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Deletes a given record in [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] table
     *----------------------------------------------------------------------------------*/
BEGIN
    BEGIN TRY
        -- Select
        SELECT  
            DefinitionId,
            ObjectDictionaryId,
            AttributeName,
            AttributeDescription,
            HasBeenDeleted,
            DeletionDiscoveryDate,
            DeletionVersionFrom,
            ReplacementDefinitionId
        FROM [TestSchemaDoc].[Docs].[SchemaObjectsAttributes]
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO



-- =================

/****** Object:  StoredProcedure [Docs].[SchemaObjectsAttributes_Update]    Script Date: 08-06-17 13:03:10 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes_Update]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectsAttributes_Update](
    @DefinitionId as bigint,
    @ObjectDictionaryId as bigint,
    @AttributeName as varchar(256),
    @AttributeDescription as varchar(4000) = NULL ,
    @HasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementDefinitionId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Updates a given record in [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- UPDATE
        UPDATE [TestSchemaDoc].[Docs].[SchemaObjectsAttributes]
            SET
                ObjectDictionaryId = ISNULL(@ObjectDictionaryId, ObjectDictionaryId),
                AttributeName = ISNULL(@AttributeName, AttributeName),
                AttributeDescription = ISNULL(@AttributeDescription, AttributeDescription),
                HasBeenDeleted = ISNULL(@HasBeenDeleted, HasBeenDeleted),
                DeletionDiscoveryDate = ISNULL(@DeletionDiscoveryDate, DeletionDiscoveryDate),
                DeletionVersionFrom = ISNULL(@DeletionVersionFrom, DeletionVersionFrom),
                ReplacementDefinitionId = ISNULL(@ReplacementDefinitionId, ReplacementDefinitionId)
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO


-- =================

/****** Object:  StoredProcedure [Docs].[SchemaObjectsAttributes_Upsert]    Script Date: 08-06-17 13:03:19 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectsAttributes_Upsert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectsAttributes_Upsert](
    @DefinitionId as bigint = NULL,
    @ObjectDictionaryId as bigint,
    @AttributeName as varchar(256),
    @AttributeDescription as varchar(4000) = NULL ,
    @HasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementDefinitionId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Inserts or updates a record into [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- Choose between INSERT AND UPDATE
        IF((SELECT COUNT(*) FROM [TestSchemaDoc].[Docs].[SchemaObjectsAttributes] WHERE 
            DefinitionId = @DefinitionId
           ) = 0)
        BEGIN
            EXEC [TestSchemaDoc].[Docs].[SchemaObjectsAttributes_Insert]
                                            @ObjectDictionaryId = @ObjectDictionaryId,
                      @AttributeName = @AttributeName,
                      @AttributeDescription = @AttributeDescription,
                      @HasBeenDeleted = @HasBeenDeleted,
                      @DeletionDiscoveryDate = @DeletionDiscoveryDate,
                      @DeletionVersionFrom = @DeletionVersionFrom,
                      @ReplacementDefinitionId = @ReplacementDefinitionId
            ;
        END
        ELSE
        BEGIN
            EXEC [TestSchemaDoc].[Docs].[SchemaObjectsAttributes_Update]
                      @DefinitionId = @DefinitionId,
                      @ObjectDictionaryId = @ObjectDictionaryId,
                      @AttributeName = @AttributeName,
                      @AttributeDescription = @AttributeDescription,
                      @HasBeenDeleted = @HasBeenDeleted,
                      @DeletionDiscoveryDate = @DeletionDiscoveryDate,
                      @DeletionVersionFrom = @DeletionVersionFrom,
                      @ReplacementDefinitionId = @ReplacementDefinitionId
            ;
        END
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO

