/****** Object:  StoredProcedure [Docs].[SchemaObjectDictionary_Delete]    Script Date: 08-06-17 13:00:44 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary_Delete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectDictionary_Delete](
    @DefinitionId as bigint
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Deletes a given record in [TestSchemaDoc].[Docs].[SchemaObjectDictionary] table
     *----------------------------------------------------------------------------------*/
BEGIN
    BEGIN TRY
        -- Delete
        DELETE [TestSchemaDoc].[Docs].[SchemaObjectDictionary]
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO


--- ================



/****** Object:  StoredProcedure [Docs].[SchemaObjectDictionary_Insert]    Script Date: 08-06-17 13:00:58 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary_Insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectDictionary_Insert](
    @ServerId as bigint = NULL ,
    @DatabaseName as varchar(256),
    @SchemaName as varchar(256),
    @ObjectName as varchar(256),
    @ObjectType as varchar(256),
    @ObjectDescription as varchar(4000) = NULL ,
    @RelatedApplicationName as varchar(256) = NULL ,
    @RelatedModuleName as varchar(256) = NULL ,
    @isDepreciated as bit = 0,
    @hasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementObjectId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Inserts a record into [TestSchemaDoc].[Docs].[SchemaObjectDictionary] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- INSERT
        INSERT [TestSchemaDoc].[Docs].[SchemaObjectDictionary](
            ServerId,
            DatabaseName,
            SchemaName,
            ObjectName,
            ObjectType,
            ObjectDescription,
            RelatedApplicationName,
            RelatedModuleName,
            isDepreciated,
            hasBeenDeleted,
            DeletionDiscoveryDate,
            DeletionVersionFrom,
            ReplacementObjectId
        )
        VALUES (
            @ServerId,
            @DatabaseName,
            @SchemaName,
            @ObjectName,
            @ObjectType,
            @ObjectDescription,
            @RelatedApplicationName,
            @RelatedModuleName,
            @isDepreciated,
            @hasBeenDeleted,
            @DeletionDiscoveryDate,
            @DeletionVersionFrom,
            @ReplacementObjectId
        );
        -- Return the new ID
        select SCOPE_IDENTITY();
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO


--- ===============


/****** Object:  StoredProcedure [Docs].[SchemaObjectDictionary_Select]    Script Date: 08-06-17 13:01:16 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary_Select]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectDictionary_Select](
    @DefinitionId as bigint
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Deletes a given record in [TestSchemaDoc].[Docs].[SchemaObjectDictionary] table
     *----------------------------------------------------------------------------------*/
BEGIN
    BEGIN TRY
        -- Select
        SELECT  
            DefinitionId,
            ServerId,
            DatabaseName,
            SchemaName,
            ObjectName,
            ObjectType,
            ObjectDescription,
            RelatedApplicationName,
            RelatedModuleName,
            isDepreciated,
            hasBeenDeleted,
            DeletionDiscoveryDate,
            DeletionVersionFrom,
            ReplacementObjectId
        FROM [TestSchemaDoc].[Docs].[SchemaObjectDictionary]
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO



--- ================

/****** Object:  StoredProcedure [Docs].[SchemaObjectDictionary_Update]    Script Date: 08-06-17 13:01:27 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary_Update]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectDictionary_Update](
    @DefinitionId as bigint,
    @ServerId as bigint = NULL ,
    @DatabaseName as varchar(256),
    @SchemaName as varchar(256),
    @ObjectName as varchar(256),
    @ObjectType as varchar(256),
    @ObjectDescription as varchar(4000) = NULL ,
    @RelatedApplicationName as varchar(256) = NULL ,
    @RelatedModuleName as varchar(256) = NULL ,
    @isDepreciated as bit = 0,
    @hasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementObjectId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Updates a given record in [TestSchemaDoc].[Docs].[SchemaObjectDictionary] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- UPDATE
        UPDATE [TestSchemaDoc].[Docs].[SchemaObjectDictionary]
            SET
                ServerId = ISNULL(@ServerId, ServerId),
                DatabaseName = ISNULL(@DatabaseName, DatabaseName),
                SchemaName = ISNULL(@SchemaName, SchemaName),
                ObjectName = ISNULL(@ObjectName, ObjectName),
                ObjectType = ISNULL(@ObjectType, ObjectType),
                ObjectDescription = ISNULL(@ObjectDescription, ObjectDescription),
                RelatedApplicationName = ISNULL(@RelatedApplicationName, RelatedApplicationName),
                RelatedModuleName = ISNULL(@RelatedModuleName, RelatedModuleName),
                isDepreciated = ISNULL(@isDepreciated, isDepreciated),
                hasBeenDeleted = ISNULL(@hasBeenDeleted, hasBeenDeleted),
                DeletionDiscoveryDate = ISNULL(@DeletionDiscoveryDate, DeletionDiscoveryDate),
                DeletionVersionFrom = ISNULL(@DeletionVersionFrom, DeletionVersionFrom),
                ReplacementObjectId = ISNULL(@ReplacementObjectId, ReplacementObjectId)
        WHERE 
            DefinitionId = @DefinitionId
        ;
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO



--- ================

/****** Object:  StoredProcedure [Docs].[SchemaObjectDictionary_Upsert]    Script Date: 08-06-17 13:01:57 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Docs].[SchemaObjectDictionary_Upsert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [Docs].[SchemaObjectDictionary_Upsert](
    @DefinitionId as bigint = NULL,
    @ServerId as bigint = NULL ,
    @DatabaseName as varchar(256),
    @SchemaName as varchar(256),
    @ObjectName as varchar(256),
    @ObjectType as varchar(256),
    @ObjectDescription as varchar(4000) = NULL ,
    @RelatedApplicationName as varchar(256) = NULL ,
    @RelatedModuleName as varchar(256) = NULL ,
    @isDepreciated as bit = 0,
    @hasBeenDeleted as bit = 0,
    @DeletionDiscoveryDate as date = NULL ,
    @DeletionVersionFrom as varchar(64) = NULL ,
    @ReplacementObjectId as bigint = NULL 
)
AS
    /*----------------------------------------------------------------------------------
     *   Author  : Automated creation
     *   Created : 20170606
     *   Description : Inserts or updates a record into [TestSchemaDoc].[Docs].[SchemaObjectDictionary] table
     *----------------------------------------------------------------------------------*/
BEGIN
    SET NOCOUNT ON;
    BEGIN TRY
        -- Choose between INSERT AND UPDATE
        IF((SELECT COUNT(*) FROM [TestSchemaDoc].[Docs].[SchemaObjectDictionary] WHERE 
            DefinitionId = @DefinitionId
           ) = 0)
        BEGIN
            EXEC [TestSchemaDoc].[Docs].[SchemaObjectDictionary_Insert]
                                            @ServerId = @ServerId,
                      @DatabaseName = @DatabaseName,
                      @SchemaName = @SchemaName,
                      @ObjectName = @ObjectName,
                      @ObjectType = @ObjectType,
                      @ObjectDescription = @ObjectDescription,
                      @RelatedApplicationName = @RelatedApplicationName,
                      @RelatedModuleName = @RelatedModuleName,
                      @isDepreciated = @isDepreciated,
                      @hasBeenDeleted = @hasBeenDeleted,
                      @DeletionDiscoveryDate = @DeletionDiscoveryDate,
                      @DeletionVersionFrom = @DeletionVersionFrom,
                      @ReplacementObjectId = @ReplacementObjectId
            ;
        END
        ELSE
        BEGIN
            EXEC [TestSchemaDoc].[Docs].[SchemaObjectDictionary_Update]
                      @DefinitionId = @DefinitionId,
                      @ServerId = @ServerId,
                      @DatabaseName = @DatabaseName,
                      @SchemaName = @SchemaName,
                      @ObjectName = @ObjectName,
                      @ObjectType = @ObjectType,
                      @ObjectDescription = @ObjectDescription,
                      @RelatedApplicationName = @RelatedApplicationName,
                      @RelatedModuleName = @RelatedModuleName,
                      @isDepreciated = @isDepreciated,
                      @hasBeenDeleted = @hasBeenDeleted,
                      @DeletionDiscoveryDate = @DeletionDiscoveryDate,
                      @DeletionVersionFrom = @DeletionVersionFrom,
                      @ReplacementObjectId = @ReplacementObjectId
            ;
        END
    END TRY
    BEGIN CATCH
        DECLARE @ErrorMessage  NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState    INT;
        select @ErrorMessage = ERROR_MESSAGE(), @ErrorSeverity = ERROR_SEVERITY(), @ErrorState = ERROR_STATE();
        IF (@@TRANCOUNT > 0)
        BEGIN
            ROLLBACK TRANSACTION;
        END;
        RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
    END CATCH
END
' 
END
GO



--- ================

