/*requires Schema.Docs.sql*/
/*requires Table.Docs.SchemaObjectDictionary.sql*/
/*requires Table.Docs.SchemaObjectsAttributes.sql*/

DECLARE @ProcedureSchema NVARCHAR(256);
DECLARE @ProcedureName   NVARCHAR(256);

SET @ProcedureSchema = 'Docs' ;
SET @ProcedureName = 'GetRelatedObjectDescriptions' ;

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('PROCEDURE [%s].[%s]',0,1,@ProcedureSchema,@ProcedureName);

IF  NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[' + @ProcedureSchema + N'].[' + @ProcedureName +  N']') AND type in (N'P'))
BEGIN
    BEGIN TRY
        EXECUTE ('CREATE Procedure [' + @ProcedureSchema + '].[' + @ProcedureName +  '] ( ' +
                ' @ServerName    varchar(512), ' +
                ' @DbName    varchar(50) ' +
                ') ' +
                'AS ' +
                'BEGIN ' +
                '   SELECT ''Not implemented'' ' +
                'END')
    END TRY
    BEGIN CATCH
        PRINT '   Error while trying to create procedure'
        RETURN
    END CATCH

    PRINT '   PROCEDURE created.'
END
GO

ALTER PROCEDURE [Docs].[GetRelatedObjectDescriptions] (
    @ServerId                           BIGINT          = NULL,
    @DatabaseName                       VARCHAR(256)    = NULL,
    @SchemaName                         VARCHAR(256)    = NULL,
    @ObjectName                         VARCHAR(256)    = NULL,
    @Debug                              BIT = 0
)
AS
/*
  ===================================================================================
    DESCRIPTION:

    PARAMETERS:

    REQUIREMENTS:

    EXAMPLE USAGE :
    
        EXEC [Docs].[GetRelatedObjectDescriptions] 
					@ServerId = NULL,
					@DatabaseName = NULL,
					@SchemaName   = NULL,
					@Debug = 1

        EXEC [Docs].[GetRelatedObjectDescriptions] 
					@ServerId = NULL,
					@DatabaseName = NULL,
					@SchemaName   = 'Docs',
					@ObjectName = 'SchemaObjectsAttributes',
					@Debug = 1


  ===================================================================================
*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @tsql               nvarchar(max);
    DECLARE @LineFeed           CHAR(2);

    SELECT
        @tsql               = '',
        @LineFeed           = CHAR(13) + CHAR(10),
        @DatabaseName       = CASE WHEN @DatabaseName IS NULL OR LEN(LTRIM(RTRIM(@DatabaseName))) = 0 THEN DB_NAME() ELSE @DatabaseName END
    ;

    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Now running [Docs].[GetRelatedObjectDescriptions] stored procedure.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;
    
    WITH ObjectsOfInterest 
    AS (
        SELECT DefinitionId,DatabaseName, SchemaName,ObjectName,ObjectType
        FROM Docs.SchemaObjectDictionary sod
        WHERE 
            ((@ServerId IS NULL AND sod.ServerId IS NULL) OR (@ServerId = sod.ServerId))
        AND (DatabaseName = @DatabaseName)
        AND (@SchemaName IS NULL OR (@SchemaName IS NOT NULL AND SchemaName = @SchemaName))
        AND (@ObjectName IS NULL OR (@ObjectName IS NOT NULL AND ObjectName = @ObjectName))
    )
    select 
        docd.DefinitionId,
        docd.ObjectDictionaryId, 
        ooi.DatabaseName,
        ooi.SchemaName,
        ooi.ObjectName,
        ooi.ObjectType,
        docd.AttributeName,
        docd.AttributeDescription,
        docd.HasBeenDeleted,
        docd.DeletionDiscoveryDate,
        docd.DeletionVersionFrom,
        docd.ReplacementDefinitionId,
		'EXEC [Docs].[SchemaObjectsAttributes_Upsert]' + CHAR(13) + CHAR(10) + 
		'           @DefinitionId            = ' + CONVERT(VARCHAR(12),docd.DefinitionId) + ',' + CHAR(13) + CHAR(10) +
		'           @ObjectDictionaryId      = ' + CONVERT(VARCHAR(12),docd.ObjectDictionaryId) + ',' + CHAR(13) + CHAR(10) +
		'           @AttributeName           = ''' + docd.AttributeName + ''',' +  CHAR(13) + CHAR(10) +
		'           @AttributeDescription    = ''' + CASE WHEN docd.AttributeDescription IS NULL THEN 'TODO:ADD_YOUR_DESCRIPTION' ELSE docd.AttributeDescription END + ''',' +  CHAR(13) + CHAR(10) +
		'           @HasBeenDeleted          = ' + CONVERT(CHAR(1),docd.HasBeenDeleted) + ',' +  CHAR(13) + CHAR(10) +
		'           @DeletionDiscoveryDate   = ' + CASE WHEN docd.DeletionDiscoveryDate IS NULL THEN 'NULL' ELSE '''' + CONVERT(VARCHAR(32),docd.DeletionDiscoveryDate,112) + '''' END + ',' +  CHAR(13) + CHAR(10) +
		'           @DeletionVersionFrom     = ' + CASE WHEN docd.DeletionVersionFrom IS NULL THEN 'NULL' ELSE '''' + docd.DeletionVersionFrom + ''''  END + ',' +  CHAR(13) + CHAR(10) +
		'           @ReplacementDefinitionId = ' + CASE WHEN docd.ReplacementDefinitionId IS NULL THEN 'NULL' ELSE CONVERT(VARCHAR(32),docd.ReplacementDefinitionId) END + CHAR(13) + CHAR(10) +
		';' as UpdateDML
    From Docs.SchemaObjectsAttributes as docd
    INNER JOIN
        ObjectsOfInterest as ooi
    ON docd.ObjectDictionaryId = ooi.Definitionid 
    
    
    
    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Execution of [Docs].[GetRelatedObjectDescriptions] completed.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;


END
GO


IF (@@ERROR = 0)
BEGIN
    PRINT '   PROCEDURE altered.';
END
ELSE
BEGIN
    PRINT '   Error while trying to alter procedure';
    RETURN
END;
GO

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('',0,1);
GO

