/*requires Schema.Docs.sql*/
/*requires Table.Docs.SchemaObjectDictionary.sql*/
/*requires Table.Docs.SchemaObjectsAttributes.sql*/
/*requires View.Docs.SchemaObjectsAttributesDetails.sql*/

DECLARE @ProcedureSchema NVARCHAR(256);
DECLARE @ProcedureName   NVARCHAR(256);

SET @ProcedureSchema = 'Docs' ;
SET @ProcedureName = 'ApplyDictionaryDefinitionsToExtendedProperties' ;

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('PROCEDURE [%s].[%s]',0,1,@ProcedureSchema,@ProcedureName);

IF  NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[' + @ProcedureSchema + N'].[' + @ProcedureName +  N']') AND type in (N'P'))
BEGIN
    BEGIN TRY
        EXECUTE ('CREATE Procedure [' + @ProcedureSchema + '].[' + @ProcedureName +  '] ( ' +
                ' @ServerName    varchar(512), ' +
                ' @DbName    varchar(50) ' +
                ') ' +
                'AS ' +
                'BEGIN ' +
                '   SELECT ''Not implemented'' ' +
                'END')
    END TRY
    BEGIN CATCH
        PRINT '   Error while trying to create procedure'
        RETURN
    END CATCH

    PRINT '   PROCEDURE created.'
END
GO

ALTER PROCEDURE [Docs].[ApplyDictionaryDefinitionsToExtendedProperties] (
    @DatabaseName                   VARCHAR(256) = NULL,
    @SchemaName                     VARCHAR(256) = NULL,
    @Debug                          BIT          = 0
)
AS
/*
  ===================================================================================
    DESCRIPTION:

    PARAMETERS:

    REQUIREMENTS:

    EXAMPLE USAGE :
    
        EXEC [Docs].[ApplyDictionaryDefinitionsToExtendedProperties] 
				@SchemaName = 'Testing',
				@Debug = 1
  ===================================================================================
*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @tsql                   nvarchar(max);
    DECLARE @LineFeed               CHAR(2);
    DECLARE @CurrentId              INT;
    DECLARE @ExecRet                INT;
    DECLARE @TmpCnt                 BIGINT;
    DECLARE @CntErrors              BIGINT;
	DECLARE @LogMsg                 VARCHAR(MAX);

    SELECT
        @tsql               = '',
        @LineFeed           = CHAR(13) + CHAR(10),
        @DatabaseName       = CASE WHEN @DatabaseName IS NULL OR LEN(LTRIM(RTRIM(@DatabaseName))) = 0 THEN DB_NAME() ELSE @DatabaseName END,
        @SchemaName         = CASE WHEN LEN(LTRIM(RTRIM(@SchemaName))) = 0 THEN NULL ELSE @SchemaName END,
        @CntErrors          = 0
    ;

    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Now running [Docs].[ApplyDictionaryDefinitionsToExtendedProperties] stored procedure.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;

    IF(OBJECT_ID('tempdb..#EEUpdateQueries') IS NOT NULL)
    BEGIN
        EXEC sp_executesql N'DROP TABLE #EEUpdateQueries;';
    END;
    
    CREATE TABLE #EEUpdateQueries (
        QueryId  INT IDENTITY(1,1),
        SqlQuery VARCHAR(MAX)
    );
    
    WITH DataSet (
        LevelType_1, DatabaseName, LevelName_0,LevelName_1,LevelName_2,PropertyValue,LevelType_2
    )
    AS (
        SELECT ObjectType ,DatabaseName,SchemaName,ObjectName,NULL as AttributeName,ObjectDescription, NULL
        From Docs.SchemaObjectDictionary
        WHERE 
            (@DatabaseName IS NULL OR DatabaseName = @DatabaseName)
        AND (@SchemaName IS NULL OR SchemaName = @SchemaName)
        AND ObjectDescription IS NOT NULL
        and hasBeenDeleted = 0
        UNION ALL
        SELECT ObjectType,DatabaseName,SchemaName,ObjectName,AttributeName,AttributeDescription, CASE WHEN SUBSTRING(AttributeName,1,1) = '@' THEN 'PARAMETER' ELSE 'COLUMN' END
        FROM Docs.SchemaObjectsAttributesDetails
        WHERE 
            (@DatabaseName IS NULL OR DatabaseName = @DatabaseName)
        AND (@SchemaName IS NULL OR SchemaName = @SchemaName)
        AND AttributeDescription IS NOT NULL
        AND DeletedAttribute= 0
    )
	INSERT INTO #EEUpdateQueries (
		SqlQuery
	)
    SELECT 
        'EXEC [Utils].[ManageExtendedProperty]' + @LineFeed +
        '               @DatabaseName   = ''' + DatabaseName + ''',' + @LineFeed +
        '               @PropertyValue	= ''' + PropertyValue + ''',' + @LineFeed +
        '               @LevelType_0	= ''SCHEMA'',' + @LineFeed + 
        '               @LevelName_0	= ''' + LevelName_0 + ''',' + @LineFeed +
        '               @LevelType_1	= ' + CASE WHEN LevelType_1 IS NULL THEN 'NULL' ELSE '''' + LevelType_1 + '''' END + ',' + @LineFeed +
        '               @LevelName_1	= ' + CASE WHEN LevelName_1 IS NULL THEN 'NULL' ELSE '''' + LevelName_1 + '''' END + ',' + @LineFeed +
        '               @LevelType_2    = ' + CASE WHEN LevelType_2 IS NULL THEN 'NULL' ELSE '''' + LevelType_2 + '''' END + ',' + @LineFeed +
        '               @LevelName_2    = ' + CASE WHEN LevelName_2 IS NULL THEN 'NULL' ELSE '''' + LevelName_2 + '''' END + ',' + @LineFeed +
        '               @Debug          = ' + CONVERT(CHAR(1) , @Debug) + @LineFeed +
        ';' as ProcCall
    FROM DataSet
    ;
    
    SELECT @TmpCnt = COUNT_BIG(*)
    FROM #EEUpdateQueries
    ;
    
    IF(@Debug = 1)
    BEGIN
        SET @LogMsg = CONVERT(VARCHAR(10),@TmpCnt) + ' queries to run';
        RAISERROR(@LogMsg,0,1);
    END;
    
    WHILE (1=1)
    BEGIN
        SET @tsql = NULL;
        
        SELECT TOP 1 @tsql = SqlQuery, @CurrentId = QueryId
        FROM #EEUpdateQueries
        ;
        
        IF(@tsql IS NULL)
        BEGIN 
            BREAK;
        END;
        
        IF(@Debug = 1)
        BEGIN
            SET @LogMsg =   'Now running following query:' + @LineFeed +
                            '==========================================================' + @LineFeed +
                            @tsql + @LineFeed +
                            '==========================================================' + @LineFeed
                            ;
                            
            RAISERROR(@LogMsg,0,1);
        END;
        
        EXEC @ExecRet = sp_executesql @tsql;
        
        IF(@ExecRet <> 0)
        BEGIN
            SET @CntErrors = @CntErrors + 1;
            SET @LogMsg =   'Unable to run following query:' + @LineFeed +
                            '==========================================================' + @LineFeed +
                            @tsql + @LineFeed +
                            '==========================================================' + @LineFeed +
                            'Error Message: ' + @LineFeed +
                            ERROR_MESSAGE() + @LineFeed +
                            '----------------------------------------------------------'
                            ;
            RAISERROR(@LogMsg,0,1);
        END;
        
        DELETE FROM #EEUpdateQueries WHERE QueryId = @CurrentId;
    END;

    IF ((SELECT COUNT_BIG(*) FROM #EEUpdateQueries) > 0)
    BEGIN
        RAISERROR('Outside loop but still queries to be run',12,1);
        SELECT * FROM #EEUpdateQueries;
        SET @CntErrors = @CntErrors + 1;
    END;
    
    IF(OBJECT_ID('tempdb..#EEUpdateQueries') IS NOT NULL)
    BEGIN
        EXEC sp_executesql N'DROP TABLE #EEUpdateQueries;';
    END;
    
    
    IF(@CntErrors > 0)
    BEGIN
        RAISERROR('One or more errors occurred',12,1);
        RETURN;
    END;

    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Execution of [Docs].[ApplyDictionaryDefinitionsToExtendedProperties] completed.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;


END
GO


IF (@@ERROR = 0)
BEGIN
    PRINT '   PROCEDURE altered.';
END
ELSE
BEGIN
    PRINT '   Error while trying to alter procedure';
    RETURN
END;
GO

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('',0,1);
GO

