/*requires Schema.Common.sql*/

/**
  ==================================================================================
    DESCRIPTION
		Creation of the [Common].[ApplicationParams] table.
		This table will contain informations about the application parameters

	==================================================================================
  BUGS:
 
    BUGID       Fixed   Description
    ==========  =====   ==========================================================
    ----------------------------------------------------------------------------------
  ==================================================================================
  Notes :
 
        Exemples :
        -------
 
  ==================================================================================
  Revision history
 
    Date        Name                Description
    ==========  ================    ================================================
    05/01/2015  Jefferson Elias     VERSION 1.0.0
    --------------------------------------------------------------------------------
    24/08/2015  Jefferson Elias     Added a column to tell whether the ParamName can 
                                    be NULL or not (ValueCanBeNULL)
                                    Removed ParamValue and DefaultValue NOT NULL clause
                                    Added a check to tell that if 
    --------------------------------------------------------------------------------
    17/09/2015  Jefferson Elias     Added a check not to override creationdate 
                                    and lastmodified at insert.
    --------------------------------------------------------------------------------
  ==================================================================================
*/

PRINT '--------------------------------------------------------------------------------------------------------------'
PRINT 'Table [ApplicationParams] Creation'

IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Common].[ApplicationParams]') AND type in (N'U'))
BEGIN
    CREATE TABLE [Common].[ApplicationParams](
        [ApplicationName]   [varchar](128)  NOT NULL,
        [ParamName]         [varchar](64)   NOT NULL,
        [ParamValue]        [varchar](max)  ,
        [DefaultValue]      [varchar](max) ,
        [ValueCanBeNULL]    [bit]           DEFAULT 0 NOT NULL,
        [isDepreciated]     [bit]           NOT NULL,
        [ParamDescription]  [varchar](max)  NULL,
        [creationdate]      [datetime]      NOT NULL,
        [lastmodified]      [datetime]      NOT NULL,

        CONSTRAINT [PK_ApplicationParams] PRIMARY KEY CLUSTERED (
            [ApplicationName] ASC,
            [ParamName] ASC
        )
        WITH (
            PAD_INDEX  = OFF,
            STATISTICS_NORECOMPUTE  = OFF,
            IGNORE_DUP_KEY = OFF,
            ALLOW_ROW_LOCKS  = ON,
            ALLOW_PAGE_LOCKS  = ON
        )
        ON [PRIMARY]
    )ON [PRIMARY]
	PRINT '   Table [Common].[ApplicationParams] created.'
END
ELSE
BEGIN		
    PRINT '   Table [Common].[ApplicationParams] already exists.'
END
GO

/**
    Rename a column to a given table 
 */
DECLARE @ColumnName     VARCHAR(128)    = QUOTENAME('Description');
DECLARE @NewColumnName  VARCHAR(128)    = 'ParamDescription';
DECLARE @FullTableName  NVARCHAR(MAX)   = N'[Common].[ApplicationParams]';
DECLARE @FullColName    NVARCHAR(MAX)   = @FullTableName + '.' + @ColumnName;
DECLARE @tsql           NVARCHAR(max);

IF EXISTS( 
    SELECT 1 
    FROM  sys.columns 
    WHERE QUOTENAME(Name) = @ColumnName and Object_ID = Object_ID(@FullTableName)
)
BEGIN
    
    execute sp_rename @FullColName,@NewColumnName,'COLUMN' ;
    
    PRINT '    Column ' + @ColumnName + ' renamed to ' + @NewColumnName + '.';
END
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Common].[CK_ApplicationParams_ValueNULL]') AND type = 'C')
BEGIN
    ALTER TABLE [Common].[ApplicationParams]
        ADD CONSTRAINT [CK_ApplicationParams_ValueNULL] CHECK (
            ValueCanBeNULL = 1
            or (
                ValueCanBeNULL = 0 and DefaultValue is not null and ParamValue is not null
            )
        )
	PRINT '   Constraint [CK_ApplicationParams_ValueNULL] created.'
END
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Common].[DF_ApplicationParams_ApplicationName]') AND type = 'D')
BEGIN
    ALTER TABLE [Common].[ApplicationParams]
        ADD CONSTRAINT [DF_ApplicationParams_ApplicationName] DEFAULT ('Default') FOR [ApplicationName]
	PRINT '   Constraint [DF_ApplicationParams_ApplicationName] created.'
END
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Common].[DF_ApplicationParams_isDepreciated]') AND type = 'D')
BEGIN
    ALTER TABLE [Common].[ApplicationParams]
        ADD CONSTRAINT [DF_ApplicationParams_isDepreciated] DEFAULT (0) FOR [isDepreciated]
	PRINT '   Constraint [DF_ApplicationParams_isDepreciated] created.'
END
GO


IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Common].[DF_ApplicationParams_creationdate]') AND type = 'D')
BEGIN
    ALTER TABLE [Common].[ApplicationParams]
        ADD CONSTRAINT [DF_ApplicationParams_creationdate] DEFAULT (Getdate()) FOR [creationdate]
	PRINT '   Constraint [DF_ApplicationParams_creationdate] created.'
END
GO

IF  NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[Common].[DF_ApplicationParams_lastmodified]') AND type = 'D')
BEGIN
    ALTER TABLE [Common].[ApplicationParams]
        ADD CONSTRAINT [DF_ApplicationParams_lastmodified] DEFAULT (Getdate()) FOR [lastmodified]
	PRINT '   Constraint [DF_ApplicationParams_lastmodified] created.'
END
GO

DECLARE @SQL VARCHAR(MAX)

IF  NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[Common].[TRG_I_ApplicationParams]'))
BEGIN
    SET @SQL = 'CREATE TRIGGER [Common].[TRG_I_ApplicationParams] ' + CHAR(13) +
               '  ON Common.ApplicationParams ' + CHAR(13) +
               '    FOR INSERT ' + CHAR(13) +
               'AS' + CHAR(13) +
               'BEGIN' + CHAR(13) +
               '    DECLARE @a varchar(MAX)' + CHAR(13) +
               '    select @a = ''123''' + CHAR(13) +
               'END' + CHAR(13);

    EXEC (@SQL) ;
	
	PRINT '   Trigger [TRG_I_ApplicationParams] created.'
END

SET @SQL =  'ALTER TRIGGER [Common].[TRG_I_ApplicationParams]' + CHAR(13) +
            '    ON Common.ApplicationParams' + CHAR(13) +
            '    FOR INSERT' +CHAR(13) +
            'AS' + CHAR(13) +
            'BEGIN' + CHAR(13) +
            '    UPDATE [Common].ApplicationParams ' + CHAR(13) +
            '        SET lastmodified = ISNULL(o.lastmodified,GETDATE())'+CHAR(13) +
            '        ,   creationdate = ISNULL(o.creationdate,GETDATE()) ' + CHAR(13) +
            '    FROM [Common].ApplicationParams o ' + CHAR(13) +
            '        INNER JOIN inserted i' +CHAR(13) +
            '    on o.[ParamName] = i.[ParamName]' +CHAR(13) +
            'END' ;
EXEC (@SQL);

PRINT '   Trigger [TRG_I_ApplicationParams] altered.'

IF  NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[Common].[TRG_U_ApplicationParams]'))
BEGIN
    SET @SQL = 'CREATE TRIGGER [Common].[TRG_U_ApplicationParams] ' + CHAR(13) +
               '  ON Common.ApplicationParams ' + CHAR(13) +
               '    FOR UPDATE ' + CHAR(13) +
               'AS' + CHAR(13) +
               'BEGIN' + CHAR(13) +
               '    DECLARE @a varchar(MAX)' + CHAR(13) +
               '    select @a = ''123''' + CHAR(13) +
               'END' + CHAR(13);

    EXEC (@SQL) ;
	PRINT '   Trigger [TRG_I_ApplicationParams] created.'
END

SET @SQL =  'ALTER TRIGGER [Common].[TRG_U_ApplicationParams]' + CHAR(13) +
            '    ON Common.ApplicationParams' + CHAR(13) +
            '    FOR UPDATE' +CHAR(13) +
            'AS' + CHAR(13) +
            'BEGIN' + CHAR(13) +
            '    UPDATE [Common].ApplicationParams ' + CHAR(13) +
            '        SET lastmodified = GETDATE()'+CHAR(13) +
            '    FROM [Common].ApplicationParams o ' + CHAR(13) +
            '        INNER JOIN inserted i' +CHAR(13) +
            '    on o.[ParamName] = i.[ParamName]' +CHAR(13) +
            'END' ;
EXEC (@SQL);
GO

PRINT '   Trigger [TRG_U_ApplicationParams] altered.'


PRINT '--------------------------------------------------------------------------------------------------------------'
PRINT '' 
GO 