/*requires Schema.Utils.sql*/

DECLARE @ProcedureSchema NVARCHAR(256);
DECLARE @ProcedureName   NVARCHAR(256);

SET @ProcedureSchema = 'Utils' ;
SET @ProcedureName = 'CheckTableExists' ;

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('PROCEDURE [%s].[%s]',0,1,@ProcedureSchema,@ProcedureName);

IF  NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[' + @ProcedureSchema + N'].[' + @ProcedureName +  N']') AND type in (N'P'))
BEGIN
    BEGIN TRY
        EXECUTE ('CREATE Procedure [' + @ProcedureSchema + '].[' + @ProcedureName +  '] ( ' +
                ' @ServerName    varchar(512), ' +
                ' @DbName    varchar(50) ' +
                ') ' +
                'AS ' +
                'BEGIN ' +
                '   SELECT ''Not implemented'' ' +
                'END')
    END TRY
    BEGIN CATCH
        PRINT '   Error while trying to create procedure'
        RETURN
    END CATCH

    PRINT '   PROCEDURE created.'
END
GO

ALTER PROCEDURE [Utils].[CheckTableExists] (
    @DatabaseName                   SYSNAME         = NULL,
    @SchemaName                     SYSNAME         = NULL,
    @TableName                      SYSNAME         = NULL,
    @RunCreateTable                 BIT             = 1,
    @TableColumnsDef                VARCHAR(MAX)    = NULL,
    @RunTruncateTable               BIT             = 0,
    @Debug                          BIT             = 0
)
AS
/*
  ===================================================================================
    DESCRIPTION:

    PARAMETERS:

    REQUIREMENTS:

    EXAMPLE USAGE :
    
        EXEC [Utils].[CheckTableExists] @Debug = 1
  ===================================================================================
*/
BEGIN
    SET NOCOUNT ON;
    DECLARE @tsql               nvarchar(max);
    DECLARE @LineFeed           CHAR(2);
	DECLARE @TmpCnt				BIGINT;
	DECLARE @ExecRet			INT;
	DECLARE @logMsg				VARCHAR(MAX);

    SELECT
        @tsql               = '',
        @LineFeed           = CHAR(13) + CHAR(10)
    ;

    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Now running [Utils].[CheckTableExists] stored procedure.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;
    
    IF(@RunCreateTable = 1 AND (@TableColumnsDef IS NULL OR LEN(@TableColumnsDef) < 4)) /* LEN('I INT') = 4*/
    BEGIN
        RAISERROR('Could not create table when column definition is not provided',12,1) WITH NOWAIT;
        RETURN;
    END;

    IF(DB_ID(@DatabaseName) IS NULL) -- no QUOTENAME (it's quoted inside DB_ID)
    BEGIN
        RAISERROR('Database %s does not exist on server.',12,1,@DatabaseName);
        RETURN;
    END;
    
    IF(@Debug = 1)
    BEGIN
        RAISERROR('-- Table to check: [%s].[%s].[%s]',0,1,@DatabaseName,@SchemaName,@TableName) WITH NOWAIT;
    END;
    
    -- check schema exists

    SET @tsql = 'SELECT @cnt = count(*) from ' + QUOTENAME(@DatabaseName) + '.sys.schemas where name = @Name';
    exec sp_executesql @tsql , N'@cnt INT OUTPUT, @Name VARCHAR(256)', @cnt = @TmpCnt OUTPUT, @Name = @SchemaName;
    if(@TmpCnt = 0)
    BEGIN
        RAISERROR('Schema %s does not exist in %s database',12,1,@SchemaName,@DatabaseName);
        RETURN;
    END;
    
    if(@TableName is not null)
    BEGIN
        -- create table if not exist.
        SET @TmpCnt = null;

        SET @tsql = 'Use ' + QUOTENAME(@DatabaseName) + '; SELECT @ObjID = OBJECT_ID(''' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName) + ''')';

        exec sp_executesql @tsql , N'@ObjID INT OUTPUT', @ObjID = @TmpCnt OUTPUT;

        if(@TmpCnt is null and @RunCreateTable = 1)
        BEGIN
            SET @tsql = 'CREATE TABLE ' + QUOTENAME(@DatabaseName) + '.' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName) + '(' +@LineFeed +
                        @TableColumnsDef + @LineFeed +
                        ')';
            exec @ExecRet = sp_executesql @tsql;
            
            IF(@ExecRet = 0) 
            BEGIN
                if(@Debug = 1)
                BEGIN
                    SET @logMsg = 'Table ' + QUOTENAME(@DatabaseName) + '.' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName) + ' created.';
                    RAISERROR(@logMsg,0,1);
                END;
            END;
            ELSE
            BEGIN
                RAISERROR('Unable to create table [%s].[%s].[%s]',12,1,@DatabaseName,@SchemaName,@TableName);
                RETURN;
            END;
        END;
        ELSE IF(@TmpCnt IS NULL AND @RunCreateTable = 0)
        BEGIN
            RAISERROR('Table does not exist.',12,1) WITH NOWAIT;
            RETURN;
        END;

        -- now the table is created.
        
        IF(@RunTruncateTable = 1)
        BEGIN
            SET @tsql = 'TRUNCATE TABLE ' + QUOTENAME(@DatabaseName) + '.' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName);
            exec sp_executesql @tsql;
            
            if(@Debug = 1)
            BEGIN
                SET @logMsg = 'Table ' + QUOTENAME(@DatabaseName) + '.' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName) + ' truncated.';
                RAISERROR(@logMsg,0,1);
            END;
        END;

    END;
    ELSE 
    BEGIN
        RAISERROR('No table name provided',12,1);
        RETURN;
    END;    

    if (@Debug = 1)
    BEGIN
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
        RAISERROR('-- Execution of [Utils].[CheckTableExists] completed.',0,1);
        RAISERROR('-- -----------------------------------------------------------------------------------------------------------------',0,1);
    END;


END
GO


IF (@@ERROR = 0)
BEGIN
    PRINT '   PROCEDURE altered.';
END
ELSE
BEGIN
    PRINT '   Error while trying to alter procedure';
    RETURN
END;
GO

RAISERROR('-----------------------------------------------------------------------------------------------------------------',0,1);
RAISERROR('',0,1);
GO

