CREATE VIEW [psa].[Timeline_H]
AS
/*
==========================================================================================
Author:      Hans Michiels
Create date: 15-FEB-2017
Description: View used for time travelling.
==========================================================================================
*/
SELECT TOP 2147483647      
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126) AS [SessionStartDtsString],
    -- If the point in time is the maximum value of the [EffectiveStartDts] of the applicable [SessionStartDts]
    -- you will select all rows that were effective/valid after this session/load.
    CONVERT(VARCHAR(30), MAX(alltables_timeline.[EffectiveStartDts]), 126) AS [PointInTimeDtsString]
FROM
    (
    SELECT DISTINCT 
        subh.[SessionStartDts], 
        subh.[EffectiveStartDts]
    FROM
        [psa].[Customer_History] subh WITH (READPAST)
    -- UNION MORE STAGING TABLE HERE WHEN APPLICABLE
    ) alltables_timeline
GROUP BY
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126)
ORDER BY 
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126)
GO

CREATE VIEW [psa].[Timeline_TH]
AS
/*
==========================================================================================
Author:      Hans Michiels
Create date: 15-FEB-2017
Description: View used for time travelling.
==========================================================================================
*/
SELECT TOP 2147483647    
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126) AS [SessionStartDtsString],
    -- If the point in time is the maximum value of the [EffectiveStartDts] of the applicable [SessionStartDts]
    -- you will select all rows that were effective/valid after this session/load.
    CONVERT(VARCHAR(30), MAX(alltables_timeline.[EffectiveStartDts]), 126) AS [PointInTimeDtsString]
FROM
    (
    SELECT DISTINCT
        subh.[SessionStartDts], 
        subh.[EffectiveStartDts]
    FROM
        [psa].[Customer_Temporal] FOR SYSTEM_TIME ALL AS subh WITH (READPAST)
    -- UNION MORE STAGING TABLE HERE WHEN APPLICABLE
    ) alltables_timeline
GROUP BY
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126)
ORDER BY 
    CONVERT(VARCHAR(30), alltables_timeline.[SessionStartDts], 126)
GO
