USE [MSSQL_E11_TemporalTables]
GO

--\
---) I use this query to check whether the data in both type of history tables is exactly the same, 
---) (except for EffectiveStartDts and EffectiveEndDts, which will be slightly different).
---) To compare all rows, remove the WHERE clause.
--/

SELECT 
    ch.FirstName , ct.FirstName,
    ch.Initials , ct.Initials,
    ch.MiddleName , ct.MiddleName,
    ch.SurName , ct.SurName,
    ch.DateOfBirth , ct.DateOfBirth,
    ch.Gender , ct.Gender,
    ch.SocialSecurityNumber , ct.SocialSecurityNumber,
    ch.Address , ct.Address,
    ch.PostalCode , ct.PostalCode,
    ch.Residence , ct.Residence,
    ch.StateOrProvince , ct.StateOrProvince,
    ch.Country , ct.Country,
    ch.RowHash , ct.RowHash,
    ch.SessionStartDts , ct.SessionStartDts,
    ch.EffectiveStartDts, ct.EffectiveStartDts, 
    ch.EffectiveEndDts, ct.EffectiveEndDts
FROM 
    [psa].[Customer_History] ch
FULL JOIN
    (
        SELECT * 
        FROM psa.Customer_Temporal
        -- By using the new syntax FOR SYSTEM_TIME ALL
        -- all rows from the temporal table, including the rows in it's history table will be returned.
        FOR SYSTEM_TIME ALL
    ) ct
    ON ct.CustomerID = ch.CustomerID
    -- Because EffectiveStartDts and EffectiveEndDts are controlled by SQL Server and cannot be changed,
    -- their values will not be exactly the same for the entire load.
    -- This is why I use a SessionStartDts (you could also use a SessionID or LoadID) to know
    -- which rows where affected during the same load.
    -- This also enables to compare the Temporal and Non-Temporal versions of the rows.
    AND ct.SessionStartDts = ch.SessionStartDts

-- /* Remove hyphens to disable WHERE
WHERE 
    ( ct.RowHash != ch.RowHash
    OR ct.RowHash IS NULL 
    OR ch.RowHash IS NULL
    )
    -- */