--\
---) Create the history table ourselves, to be used as a backing table 
---) for a Temporal table, so we can tweak it for optimal performance.
---) Please note that I use the datatype DATETIME2(2) because it
---) uses 6 bytes storage, whereas DATETIME2(7) uses 8 bytes.
---) If the centiseconds precision of DATETIME2(2) is not enough
---) in your data warehouse, you can change it to DATETIME2(7).
--/
CREATE TABLE [psa].[Customer_TemporalHistory]
(    
  [CustomerID] INT NOT NULL,
  [FirstName] NVARCHAR(20) NULL,
  [Initials] NVARCHAR(20) NULL,
  [MiddleName] NVARCHAR(20) NULL,
  [SurName] NVARCHAR(50) NOT NULL,
  [DateOfBirth] DATE NOT NULL,
  [Gender] CHAR(1) NOT NULL,
  [SocialSecurityNumber] CHAR(12) NOT NULL,
  [Address] NVARCHAR(60) NOT NULL,
  [PostalCode] CHAR(10) NULL,
  [Residence] NVARCHAR(60) NULL,
  [StateOrProvince] NVARCHAR(20) NULL,
  [Country] NVARCHAR(60) NULL,
  [RowHash] BINARY(16), 
  [SessionStartDts] DATETIME2(2) NOT NULL, 
  [EffectiveStartDts] DATETIME2(2) NOT NULL, 
  [EffectiveEndDts] DATETIME2(2) NOT NULL
);
GO

--\
---) Add indexes to history table
--/
CREATE CLUSTERED COLUMNSTORE INDEX [IXCS_Customer_TemporalHistory]
  ON [psa].[Customer_TemporalHistory];

CREATE NONCLUSTERED INDEX [IXNC_Customer_TemporalHistory__EffectiveEndDts_EffectiveStartDts_CustomerID]
  ON [psa].[Customer_TemporalHistory] 
    ([EffectiveEndDts], [EffectiveStartDts], [CustomerID]);

GO
                   
--\
---) Now create the temporal table
--/
CREATE TABLE [psa].[Customer_Temporal]
(    
  [CustomerID] INT NOT NULL,
  [FirstName] NVARCHAR(20) NULL,
  [Initials] NVARCHAR(20) NULL,
  [MiddleName] NVARCHAR(20) NULL,
  [SurName] NVARCHAR(50) NOT NULL,
  [DateOfBirth] DATE NOT NULL,
  [Gender] CHAR(1) NOT NULL,
  [SocialSecurityNumber] CHAR(12) NOT NULL,
  [Address] NVARCHAR(60) NOT NULL,
  [PostalCode] CHAR(10) NULL,
  [Residence] NVARCHAR(60) NULL,
  [StateOrProvince] NVARCHAR(20) NULL,
  [Country] NVARCHAR(60) NULL,
  [RowHash] BINARY(16), 
  [SessionStartDts] DATETIME2(2) NOT NULL,
  -- SessionStartDts is manually set, and is the same for all 
  -- rows of the same session/loadcycle.
  CONSTRAINT [PK_Customer_Temporal]
    PRIMARY KEY CLUSTERED  ([CustomerID] ASC), 
  [EffectiveStartDts] DATETIME2(2) GENERATED ALWAYS AS ROW START NOT NULL,
  [EffectiveEndDts] DATETIME2(2) GENERATED ALWAYS AS ROW END NOT NULL,
  PERIOD FOR SYSTEM_TIME ([EffectiveStartDts], [EffectiveEndDts]) 
)
WITH (SYSTEM_VERSIONING = ON (HISTORY_TABLE = [psa].[Customer_TemporalHistory])); 
GO

-- Add a few indexes.
CREATE NONCLUSTERED INDEX [IXNC_Customer_Temporal__EffectiveEndDts_EffectiveStartDts_CustomerID]
  ON [psa].[Customer_Temporal] 
    ([EffectiveEndDts], [EffectiveStartDts], [CustomerID]);

CREATE NONCLUSTERED INDEX [IXNC_Customer_Temporal__CustomerID_RowHash]
  ON [psa].[Customer_Temporal] 
    ([CustomerID], [RowHash]);
GO