USE [MSSQL_E11_TemporalTables]
GO
--\
---) Preparations
--/
DECLARE @num_rows INT = 500000

 EXEC [test].[spLoadInitialData] @num_rows;


IF OBJECT_ID('[test].[LoadTestResults]', 'U') IS NOT NULL
BEGIN
	DROP TABLE [test].[LoadTestResults];
END

SELECT TOP 0 
  CONVERT(VARCHAR(50), 'text') AS [scenario], 
  CONVERT(INT, 1) AS [iteration],
  DATEDIFF(ms, GETDATE(), GETDATE()) AS [elapsed_ms]
INTO [test].[LoadTestResults];


--\
---) Simulate 50 loads that fill the [stg].[Customer] table with rows that are partly different 
---) (new rows, deleted rows, rows with updates) from the previous load.
--/
DECLARE @i INT = 0
DECLARE @msg VARCHAR(100)

WHILE @i < 50
BEGIN
    SELECT @msg = CONVERT(VARCHAR(30), GETDATE(), 126) + ': iteration ' + CONVERT(VARCHAR(12), @i) + ' started ..'
    RAISERROR(@msg, 0, 1) WITH NOWAIT;

    EXEC [test].[spSimulateNewLoad] @i, @num_rows 

    EXEC [test].[spLoadTest] @i

    SET @i = @i + 1
    WAITFOR DELAY '00:00:01'
END

GO


SELECT 
    [scenario], 
    AVG([elapsed_ms]) AS [avg_elapsed_ms]  
FROM 
    [test].[LoadTestResults]
GROUP BY 
    [scenario];

SELECT * FROM [test].[LoadTestResults];
