USE [MSSQL_E11_TemporalTables]
GO

-------------- [test].[spSimulateNewLoad] --------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[test].[spSimulateNewLoad]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [test].[spSimulateNewLoad]
GO
/*
==========================================================================================
Author      : Hans Michiels
Create date : 2017-02-10
Description : Simulates a new load into the non-persistent staging table by updating,
              inserting and deleting some rows.
==========================================================================================
*/
CREATE PROCEDURE [test].[spSimulateNewLoad]
( 
  @iteration INT,
  @num_rows INT 
)
AS
BEGIN
    DECLARE @SessionStartDts DATETIME2(2) = GETUTCDATE();
    DECLARE @FivePercent INT = @num_rows / 20
    DECLARE @TwoPercent INT = @num_rows / 50

    UPDATE 
       cust
    SET 
      [DateOfBirth] = new.[DateOfBirth],
      [Country] = new.[Country],
      [SessionStartDts] = @SessionStartDts,
      [RowHash] = CONVERT(BINARY(16), 
              HASHBYTES('MD5',
                UPPER(
                  CONCAT( ISNULL(CONVERT(NVARCHAR(60), cust.[CustomerID]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[FirstName]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[Initials]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[MiddleName]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), new.[DateOfBirth], 112), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[Gender]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[SocialSecurityNumber]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[Address]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[PostalCode]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[Residence]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), cust.[StateOrProvince]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), new.[Country]), N'')
                  ) -- END CONCAT
                ) -- END UPPER
              ) -- END HASHBYTES 
          ) -- END CONVERT 
    FROM
        [stg_internal].[Customer] AS cust
    CROSS APPLY
        (
        SELECT TOP 1 * FROM [stg_internal].[Customer] WHERE [CustomerID] >= @iteration * @TwoPercent
        ) new
    WHERE 
      cust.[CustomerID] % 20 = @iteration;


    DELETE 
    FROM
        [stg_internal].[Customer] 
    WHERE 
      [CustomerID] % 200 = @iteration - 1;


    INSERT INTO [stg_internal].[Customer]
        (
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
        )
    SELECT *
    FROM
        (
        SELECT TOP (@num_rows * 3)
            q1.[CustomerID],
            q1.[FirstName],
            q1.[Initials],
            q1.[MiddleName],
            q1.[SurName],
            q1.[DateOfBirth],
            q1.[Gender],
            q1.[SocialSecurityNumber],
            q1.[Address],
            q1.[PostalCode],
            q1.[Residence],
            q1.[StateOrProvince],
            q1.[Country],
            CONVERT(BINARY(16), 
                  HASHBYTES('MD5',
                    UPPER(
                      CONCAT( ISNULL(CONVERT(NVARCHAR(60), q1.[CustomerID]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[FirstName]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[Initials]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[MiddleName]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[DateOfBirth], 112), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[Gender]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[SocialSecurityNumber]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[Address]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[PostalCode]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[Residence]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[StateOrProvince]), N'')
                            , ';', ISNULL(CONVERT(NVARCHAR(60), q1.[Country]), N'')
                      ) -- END CONCAT
                    ) -- END UPPER
                  ) -- END HASHBYTES 
              ) -- END CONVERT 
              AS [RowHash],
              q1.[SessionStartDts]
        FROM
            (
            SELECT 
                ROW_NUMBER() OVER (ORDER BY (SELECT NULL)) AS [CustomerID],
                fn.[FirstName],
                it.[Initials],
                mn.[MiddleName],
                sn.[SurName],
                db.[DateOfBirth],
                gn.[Gender],
                RIGHT('00000000000' + CONVERT(VARCHAR(20), CONVERT(BIGINT, CONVERT(BINARY(6), NEWID()))), 12) AS [SocialSecurityNumber],
                ad.[Address],
                pc.[PostalCode],
                rs.[Residence],
                sp.[StateOrProvince],
                co.[Country],
                @SessionStartDts AS [SessionStartDts]
            FROM (
                SELECT N'Hans' AS [FirstName] 
                UNION SELECT N'Bill' 
                UNION SELECT N'Larry' 
                UNION SELECT N'Virginia'
                ) fn
            CROSS JOIN (
                SELECT N'H.' AS [Initials] 
                UNION SELECT N'B.' 
                UNION SELECT N'L.' 
                UNION SELECT N'q1.'
                ) it
            CROSS JOIN (
                SELECT N'van' AS [MiddleName] 
                UNION SELECT N'van der' 
                UNION SELECT N'de' 
                UNION SELECT NULL
                ) mn
            CROSS JOIN (
                SELECT N'Michiels' AS [SurName] 
                UNION SELECT N'Billson' 
                UNION SELECT N'Larryson' 
                UNION SELECT N'Johnson'
                ) sn
            CROSS JOIN ( 
                SELECT CONVERT(DATE, N'20030303', 112) AS [DateOfBirth] 
                UNION SELECT CONVERT(DATE, N'19980808', 112) 
                UNION SELECT CONVERT(DATE, N'19850909', 112) 
                UNION SELECT CONVERT(DATE, N'19781101', 112) 
                UNION SELECT CONVERT(DATE, N'19690404', 112) 
                UNION SELECT CONVERT(DATE, N'19530505', 112) 
                UNION SELECT CONVERT(DATE, N'19421231', 112)
                ) db
            CROSS JOIN (
                SELECT N'M' AS [Gender] 
                UNION SELECT N'F'
                ) gn
            CROSS JOIN (
                SELECT N'Dorpsstraat 12' AS [Address] 
                UNION SELECT N'Scheepstraat 23' 
                UNION SELECT N'Ammerlaan 97'
                UNION SELECT N'Het Hofje 598'
                UNION SELECT N'Wegisweg 17a'
                UNION SELECT N'Banaanlaan 11'
                ) ad
            CROSS JOIN (
                SELECT N'3600 BB' AS [PostalCode] 
                UNION SELECT N'5531 BH' 
                UNION SELECT N'3923 AL' 
                UNION SELECT N'7813 YU' 
                UNION SELECT N'1307 LP' 
                UNION SELECT N'9988 ER' 
                UNION SELECT N'1614 MH'
                ) pc
            CROSS JOIN (
                SELECT N'Maarssen' AS [Residence] 
                UNION SELECT N'Bladel' 
                UNION SELECT N'Lutjebroek'
                UNION SELECT N'Gorinchem'
                UNION SELECT N'Blaricum'
                UNION SELECT N'Kruisland'
                ) rs
            CROSS JOIN (
                SELECT N'UTR' AS [StateOrProvince] 
                UNION SELECT N'NB' 
                UNION SELECT N'NH'
                UNION SELECT N'ZH' 
                UNION SELECT N'GR'
                UNION SELECT N'FR'
                UNION SELECT N'DR'
                UNION SELECT N'LI'
                UNION SELECT N'ZE'
                UNION SELECT N'GE'
                UNION SELECT N'OV'
                ) sp
            CROSS JOIN (
                SELECT N'The Netherlands' AS [Country] 
                UNION SELECT N'United States' 
                UNION SELECT N'United Kingdom'
                ) co
            ) q1
      ) q2
    WHERE q2.[CustomerID] > (@num_rows + (@iteration * @FivePercent))
      AND q2.[CustomerID] < (@num_rows + ((@iteration + 1) * @FivePercent))

END