USE [MSSQL_E11_TemporalTables]
GO

-------------- [test].[spLoadTest] --------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[test].[spLoadTest]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [test].[spLoadTest]
GO
/*
==========================================================================================
Author      : Hans Michiels
Create date : 2017-02-10
Description : Load performance test implemented in a stored procedure.
==========================================================================================
*/
CREATE PROCEDURE [test].[spLoadTest]
( @iteration INT )
AS
BEGIN
    --\
    ---) spLoadTest PSA Temporal
    --/

    DECLARE @started DATETIME2(7) 
    DECLARE @finished DATETIME2(7) 

    SET @started = GETUTCDATE();

    -- Handle absent records in the staging table.
    DELETE FROM psac
    FROM 
        [psa].[Customer_Temporal] psac
    WHERE NOT EXISTS
        (
        SELECT 1 
        FROM [stg].[Customer] stgc
        WHERE stgc.CustomerID = psac.CustomerID
        );

    -- Handle changes in the staging table.
    UPDATE psac
    SET 
        CustomerID = stgc.CustomerID,
        FirstName = stgc.FirstName,
        Initials = stgc.Initials,
        MiddleName = stgc.MiddleName,
        SurName = stgc.SurName,
        DateOfBirth = stgc.DateOfBirth,
        Gender = stgc.Gender,
        SocialSecurityNumber = stgc.SocialSecurityNumber,
        Address = stgc.Address,
        PostalCode = stgc.PostalCode,
        Residence = stgc.Residence,
        StateOrProvince = stgc.StateOrProvince,
        Country = stgc.Country,
        RowHash = stgc.RowHash,
        SessionStartDts = stgc.SessionStartDts
    FROM 
        [psa].[Customer_Temporal] psac
    JOIN 
        [stg].[Customer] stgc
        ON stgc.CustomerID = psac.CustomerID
    WHERE 
        psac.RowHash != stgc.RowHash;

    -- Handle new records in the staging table.
    INSERT INTO [psa].[Customer_Temporal]
        (
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
        )
    SELECT 
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
    FROM 
        [stg].[Customer] stgc
    WHERE NOT EXISTS
        (
        SELECT 1 
        FROM [psa].[Customer_Temporal] psac
        WHERE stgc.CustomerID = psac.CustomerID
        );

    SET @finished = GETUTCDATE();

    INSERT INTO [test].[LoadTestResults]([scenario], [iteration], [elapsed_ms])
    SELECT 
        CONVERT(VARCHAR(50), 'Synchonize PSA Temporal') AS [scenario], 
        @iteration AS [iteration],
        DATEDIFF(ms, @started, @finished) AS [elapsed_ms]


    DECLARE @Infinity DATETIME2(2) = '9999-12-31 23:59:59.99'

    SET @started = GETUTCDATE();

    -- Handle absent records in the staging table.
    UPDATE psach
        SET EffectiveEndDts = SessionStartDts
    FROM 
        [psa].[Customer_History] psach
    WHERE NOT EXISTS
        (
        SELECT 1 
        FROM [stg].[Customer] stgc
        WHERE stgc.CustomerID = psach.CustomerID
        )
    AND 
        psach.EffectiveEndDts = @Infinity ;

    -- Handle changes in the staging table.
    INSERT INTO [psa].[Customer_History]
        (
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts],
        [EffectiveStartDts],
        [EffectiveEndDts]
        )
    SELECT
        stgc.[CustomerID],
        stgc.[FirstName],
        stgc.[Initials],
        stgc.[MiddleName],
        stgc.[SurName],
        stgc.[DateOfBirth],
        stgc.[Gender],
        stgc.[SocialSecurityNumber],
        stgc.[Address],
        stgc.[PostalCode],
        stgc.[Residence],
        stgc.[StateOrProvince],
        stgc.[Country],
        stgc.[RowHash],
        stgc.[SessionStartDts],
        stgc.[SessionStartDts] AS [EffectiveStartDts],
        @Infinity AS [EffectiveEndDts]
    FROM 
        [stg].[Customer] AS stgc
    JOIN 
        [psa].[Customer_History] psach
        ON stgc.CustomerID = psach.CustomerID
    WHERE 
        psach.RowHash != stgc.RowHash
        AND psach.EffectiveEndDts = @Infinity;

    UPDATE 
        data_older
    SET 
        [EffectiveEndDts] = stgc.SessionStartDts
    FROM 
        [stg].[Customer] AS stgc
    JOIN 
        [psa].[Customer_History] AS data_changed
        ON data_changed.CustomerID = stgc.CustomerID
        AND data_changed.[EffectiveEndDts] = @Infinity
        AND data_changed.[SessionStartDts] = stgc.SessionStartDts
    JOIN 
        [psa].[Customer_History] AS data_older
        ON data_older.CustomerID = data_changed.CustomerID
        AND data_older.[EffectiveEndDts] = @Infinity
        AND data_older.[SessionStartDts] < stgc.SessionStartDts;

    -- Handle new records in the staging table.
    INSERT INTO [psa].[Customer_History]
        (
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts],
        [EffectiveStartDts],
        [EffectiveEndDts]
        )
    SELECT
        stgc.[CustomerID],
        stgc.[FirstName],
        stgc.[Initials],
        stgc.[MiddleName],
        stgc.[SurName],
        stgc.[DateOfBirth],
        stgc.[Gender],
        stgc.[SocialSecurityNumber],
        stgc.[Address],
        stgc.[PostalCode],
        stgc.[Residence],
        stgc.[StateOrProvince],
        stgc.[Country],
        stgc.[RowHash],
        stgc.[SessionStartDts],
        stgc.[SessionStartDts] AS [EffectiveStartDts],
        @Infinity AS [EffectiveEndDts]
    FROM 
        [stg].[Customer] stgc
    WHERE NOT EXISTS
        (
        SELECT 1 
        FROM [psa].[Customer_History] psach
        WHERE stgc.CustomerID = psach.CustomerID
        );

    SET @finished = GETUTCDATE();

    INSERT INTO [test].[LoadTestResults]([scenario], [iteration], [elapsed_ms])
    SELECT 
        CONVERT(VARCHAR(50), 'Synchonize PSA Non-Temporal') AS [scenario], 
        @iteration AS [iteration],
        DATEDIFF(ms, @started, @finished) AS [elapsed_ms]
END