USE [MSSQL_E11_TemporalTables]
GO

-------------- [test].[spLoadInitialData] --------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[test].[spLoadInitialData]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [test].[spLoadInitialData]
GO
/*
==========================================================================================
Author      : Hans Michiels
Create date : 2017-02-10
Description : Load initial dummy data needed for the tests.
==========================================================================================
*/
CREATE PROCEDURE [test].[spLoadInitialData]
( @num_rows INT )
AS
BEGIN

    IF EXISTS(SELECT 1 FROM [stg_internal].[Customer])
    BEGIN
      RETURN 0;
    END
    --\
    ---) Simulate that a staging table is loaded during an ETL process.
    --/
    DECLARE @SessionStartDts DATETIME2(2) = GETUTCDATE();

    INSERT INTO [stg_internal].[Customer]
        (
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
        )
    SELECT TOP (@num_rows)
        v.[CustomerID],
        v.[FirstName],
        v.[Initials],
        v.[MiddleName],
        v.[SurName],
        v.[DateOfBirth],
        v.[Gender],
        v.[SocialSecurityNumber],
        v.[Address],
        v.[PostalCode],
        v.[Residence],
        v.[StateOrProvince],
        v.[Country],
        CONVERT(BINARY(16), 
              HASHBYTES('MD5',
                UPPER(
                  CONCAT( ISNULL(CONVERT(NVARCHAR(60), v.[CustomerID]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[FirstName]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[Initials]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[MiddleName]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[DateOfBirth], 112), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[Gender]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[SocialSecurityNumber]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[Address]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[PostalCode]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[Residence]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[StateOrProvince]), N'')
                        , ';', ISNULL(CONVERT(NVARCHAR(60), v.[Country]), N'')
                  ) -- END CONCAT
                ) -- END UPPER
              ) -- END HASHBYTES 
          ) -- END CONVERT 
          AS [RowHash],
          v.[SessionStartDts]
    FROM
        (
        SELECT 
            ROW_NUMBER() OVER (ORDER BY (SELECT NULL)) AS [CustomerID],
            fn.[FirstName],
            it.[Initials],
            mn.[MiddleName],
            sn.[SurName],
            db.[DateOfBirth],
            gn.[Gender],
            RIGHT('00000000000' + CONVERT(VARCHAR(20), CONVERT(BIGINT, CONVERT(BINARY(6), NEWID()))), 12) AS [SocialSecurityNumber],
            ad.[Address],
            pc.[PostalCode],
            rs.[Residence],
            sp.[StateOrProvince],
            co.[Country],
            @SessionStartDts AS [SessionStartDts]
        --SELECT COUNT(*) AS [cnt]
        FROM (
            SELECT N'Hans' AS [FirstName] 
            UNION SELECT N'Bill' 
            UNION SELECT N'Larry' 
            UNION SELECT N'Virginia'
            ) fn
        CROSS JOIN (
            SELECT N'H.' AS [Initials] 
            UNION SELECT N'B.' 
            UNION SELECT N'L.' 
            UNION SELECT N'V.'
            ) it
        CROSS JOIN (
            SELECT N'van' AS [MiddleName] 
            UNION SELECT N'van der' 
            UNION SELECT N'de' 
            UNION SELECT NULL
            ) mn
        CROSS JOIN (
            SELECT N'Michiels' AS [SurName] 
            UNION SELECT N'Billson' 
            UNION SELECT N'Larryson' 
            UNION SELECT N'Johnson'
            ) sn
        CROSS JOIN ( 
            SELECT CONVERT(DATE, N'20030303', 112) AS [DateOfBirth] 
            UNION SELECT CONVERT(DATE, N'19980808', 112) 
            UNION SELECT CONVERT(DATE, N'19850909', 112) 
            UNION SELECT CONVERT(DATE, N'19781101', 112) 
            UNION SELECT CONVERT(DATE, N'19690404', 112) 
            UNION SELECT CONVERT(DATE, N'19530505', 112) 
            UNION SELECT CONVERT(DATE, N'19421231', 112)
            ) db
        CROSS JOIN (
            SELECT N'M' AS [Gender] 
            UNION SELECT N'F'
            ) gn
        CROSS JOIN (
            SELECT N'Dorpsstraat 12' AS [Address] 
            UNION SELECT N'Scheepstraat 23' 
            UNION SELECT N'Ammerlaan 97'
            UNION SELECT N'Het Hofje 598'
            UNION SELECT N'Wegisweg 17a'
            UNION SELECT N'Banaanlaan 11'
            ) ad
        CROSS JOIN (
            SELECT N'3600 BB' AS [PostalCode] 
            UNION SELECT N'5531 BH' 
            UNION SELECT N'3923 AL' 
            UNION SELECT N'7813 YU' 
            UNION SELECT N'1307 LP' 
            UNION SELECT N'9988 ER' 
            UNION SELECT N'1614 MH'
            ) pc
        CROSS JOIN (
            SELECT N'Maarssen' AS [Residence] 
            UNION SELECT N'Bladel' 
            UNION SELECT N'Lutjebroek'
            UNION SELECT N'Gorinchem'
            UNION SELECT N'Blaricum'
            UNION SELECT N'Kruisland'
            ) rs
        CROSS JOIN (
            SELECT N'UTR' AS [StateOrProvince] 
            UNION SELECT N'NB' 
            UNION SELECT N'NH'
            UNION SELECT N'ZH' 
            UNION SELECT N'GR'
            UNION SELECT N'FR'
            UNION SELECT N'DR'
            UNION SELECT N'LI'
            UNION SELECT N'ZE'
            UNION SELECT N'GE'
            UNION SELECT N'OV'
            ) sp
        CROSS JOIN (
            SELECT N'The Netherlands' AS [Country] 
            UNION SELECT N'United States' 
            UNION SELECT N'United Kingdom'
            ) co
        ) v

    --\
    ---) Now copy the rows to both versions of the PSA:
    ---) - Plain 'non-temporal' history
    ---) - Temporal history
    --/

    DECLARE @Infinity DATETIME2(2) = '9999-12-31 23:59:59.99'

    INSERT INTO [psa].[Customer_History]
        ([CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts],
        [EffectiveStartDts],
        [EffectiveEndDts]
        )
    SELECT
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts],
        [SessionStartDts] AS [EffectiveStartDts],
        @Infinity AS [EffectiveEndDts]
    FROM 
        [stg].[Customer];

    INSERT INTO [psa].[Customer_Temporal]
        ([CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
        )
    SELECT
        [CustomerID],
        [FirstName],
        [Initials],
        [MiddleName],
        [SurName],
        [DateOfBirth],
        [Gender],
        [SocialSecurityNumber],
        [Address],
        [PostalCode],
        [Residence],
        [StateOrProvince],
        [Country],
        [RowHash],
        [SessionStartDts]
    FROM 
        [stg].[Customer];

END