USE [CG_M_DB_DBAMON]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =====================================================================
-- Author:  Sifiso Ndlovu
-- Create date: 2016/11/17
-- Description:	Send out details of SSIS Catalog package errors
-- =====================================================================
CREATE PROCEDURE [dbo].[spSendEmailISCatalog]
	@EmailTo VARCHAR(200),
	@Subject VARCHAR(50)
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @server sysname, @Severity INT = 1
	
	SELECT @server = cast(serverproperty('servername') as sysname)

	DECLARE @SeverityDescription VARCHAR(20)
	SET @SeverityDescription = 'CRITICAL'

	DECLARE @SeverityColor VARCHAR(20)
	SET @SeverityColor = 'RED'

	DECLARE @message_ VARCHAR(max)
	DECLARE @message_time_ VARCHAR(50)
	DECLARE @tmpSQL VARCHAR(max) = '' 
	DECLARE @cnt int = 0

	DECLARE db_cursor CURSOR FOR  
		SELECT  message_time,[message]
		FROM    SSISDB.catalog.event_messages em
		WHERE   em.operation_id = (
		    SELECT MAX([execution_id]) 
		    FROM [SSISDB].[internal].[executions] (nolock) 
		    where [package_name] = 'PackageTest.dtsx'
		)
		  AND event_name NOT LIKE '%Validate%'
		  AND event_name = 'OnError'

	OPEN db_cursor   
	FETCH NEXT FROM db_cursor INTO @message_time_, @message_   

	WHILE @@FETCH_STATUS = 0   
	BEGIN   
		   set @cnt = @cnt + 1
		   set @tmpSQL = @tmpSQL + '<tr>
				<td align="left">Message ('+convert(varchar,@cnt)+') <br/> '+@message_time_+'</td>
				<td align="center">' + @message_ + '</td>
			</tr>'

		   FETCH NEXT FROM db_cursor INTO @message_time_, @message_   
	END   

	CLOSE db_cursor   
	DEALLOCATE db_cursor

	DECLARE @body1 nvarchar(max)
	SET @body1 = 
	'<html>
	<head></head>
	<body style="background: #ffffff; color: #003399"> 
		<table border="1" align="center"  cellpadding="3"  width="500">
			<tr>
				<td align="center" colspan="2" style="font-size:24;color:#003399"><b>Data Warehouse</b></td>
			</tr>
			<tr>
				<td align="center" colspan="2" style="font-size:16"><b>Automated Database Mail Alert</b></td>
			</tr>
			<tr>
				<td align="left">DATE:</td>
				<td align="center">' + convert(char(19),getdate(),20) + '</td>
			</tr>
			<tr>
				<td align="left">SERVER:</td>
				<td align="center">' + @server + '</td>
			</tr>
			' + @tmpSQL + '
			<tr>
				<td align="left">SEVERITY:</td>
				<td align="center" style="color:' + @SeverityColor + '"><b>' + @SeverityDescription + '</b></td>
			</tr>
		</table>
	</body>
	</html>'
--** SEND EMAIL **--

	DECLARE @subject1 nvarchar(70)
	SET @subject1 = @server + ' ' + @SeverityDescription + ' ' + @Subject
	EXEC msdb.dbo.sp_send_dbmail @recipients=@EmailTo,
		@subject = @subject1,
		@body = @body1,
		@body_format = 'HTML',
		@profile_name = 'DBA Admin Profile';

END

