USE [msdb];
GO

/****** Object:  StoredProcedure [dbo].[DMV_BackupAll]    Script Date: 09/03/38 03:10:56  ******/
SET ANSI_NULLS ON;
GO

SET QUOTED_IDENTIFIER ON;
GO

/*
-- =============================================
-- Author:      Mustafa Elmasry
-- Last Update date: 20/11/2016
-- Description:SQL Server Backup solution
      @start_DB_ID            >>> ID of the first DB we need to backup it
      @END_DB_ID              >>> ID of the Last DB we need to backup it
      @FULLTapeBackupLocation >>> FULL Backup location
	 @FULLBackup             >>> 0 no backup , 1 take backup
      @FULLoverwrite          >>> 0 append , 1 overwrite
      @DIFFTapeBackupLocation >>> DIFF Backup location
      @DiffBackup             >>> 0 no backup , 1 take backup
      @DIFFoverwrite          >>> 0 append , 1 overwrite
      @LOGBackupLocation      >>> Log Backup location
      @LOGBackup              >>> 0 no backup , 1 take backup
      @LOGoverwrite           >>> 0 append , 1 overwrite
      @COMPRESSION            >>> 0 No COMPRESSION , 1 apply COMPRESSION
      @Job_Name               >>> SQL Server Job Name
      @Exceptionlist_DBs Exceptionlist READONLY ,
      @p_recipients           >>> DB Admin Email
-- =============================================
*/

CREATE PROCEDURE [dbo].[DMV_BackupAll_new20112016]
    (
      @start_DB_ID INT ,
      @END_DB_ID INT ,
      @FULLTapeBackupLocation VARCHAR(500) ,
      @FULLBackup INT = 0 , ----0 no backup , 1 take backup
      @FULLoverwrite INT = 0 , ---- 0 append , 1 overwrite
      @DIFFTapeBackupLocation VARCHAR(500) ,
      @DiffBackup INT = 0 ,
      @DIFFoverwrite INT = 0 , ---- 0 append , 1 overwrite
      @LOGBackupLocation VARCHAR(500) ,
      @LOGBackup INT = 0 ,
      @LOGoverwrite INT = 0 , ---- 0 append , 1 overwrite
      @COMPRESSION INT = 0 , ----0 No COMPRESSION , 1 apply COMPRESSION
      @Job_Name NVARCHAR(50) = 'No Job Name' ,
      @Exceptionlist_DBs Exceptionlist READONLY ,
      @p_recipients NVARCHAR(1000)
    )
AS
    BEGIN 
        SET NOCOUNT ON;
----Paramter defination
        DECLARE @recovery_model INT; 
        ----DECLARE @TXLLOGTypeName VARCHAR(20);
        DECLARE @OverwriteTypeName VARCHAR(20);
        DECLARE @name NVARCHAR(500);
        DECLARE @sql NVARCHAR(MAX) = N'';
        DECLARE @p_body AS NVARCHAR(MAX) ,
            @p_subject AS NVARCHAR(MAX) ,
            @p_profile_name AS NVARCHAR(MAX); 
        SET @p_subject = N'Backup failed on Job Name''' + @Job_Name
            + ''' On Server ' + ( CAST(( SELECT SERVERPROPERTY('ServerName')
                                       ) AS NVARCHAR) ); 
        DECLARE @msg VARCHAR(MAX); 
        DECLARE @patherror VARCHAR(50);


--------------------------------------------------------------------------------------------------------------

----Check path for @FULLTapeBackupLocation
        DECLARE @FileName VARCHAR(255);
        DECLARE @IsExist INT;
        DECLARE @Temp TABLE
            (
              File_Exist INT ,
              Directory INT ,
              Parent INT
            ); 
        SELECT  @FileName = @FULLTapeBackupLocation;
        INSERT  INTO @Temp
                EXEC master.dbo.xp_fileexist @FileName;
        SET @IsExist = ( SELECT Directory
                         FROM   @Temp
                       );

----Check path for @DIFFTapeBackupLocation
        DECLARE @FileName3 VARCHAR(255);
        DECLARE @IsExist3 INT;
        DECLARE @Temp3 TABLE
            (
              File_Exist INT ,
              Directory INT ,
              Parent INT
            ); 
        SELECT  @FileName3 = @DIFFTapeBackupLocation;
        INSERT  INTO @Temp3
                EXEC master.dbo.xp_fileexist @FileName3;
        SET @IsExist3 = ( SELECT    Directory
                          FROM      @Temp3
                        );

---- Check Path @LOGBackupLocation
        DECLARE @FileName2 VARCHAR(255);
        DECLARE @IsExist2 INT;
        DECLARE @Temp2 TABLE
            (
              File_Exist INT ,
              Directory INT ,
              Parent INT
            ); 
        SELECT  @FileName2 = @LOGBackupLocation;
        INSERT  INTO @Temp2
                EXEC master.dbo.xp_fileexist @FileName2;
        SET @IsExist2 = ( SELECT    Directory
                          FROM      @Temp2
                        );

----Send Error massage
        IF ( ISNULL(@IsExist, 0) <> 1 )
            OR ( ISNULL(@IsExist2, 0) <> 1 )
            OR ( ISNULL(@IsExist3, 0) <> 1 )
            BEGIN
                SET @patherror = ' Because This Path  '''
                    + @FULLTapeBackupLocation + ''' or this Path '''
                    + @LOGBackupLocation + ''' or this Path '''
                    + @DIFFTapeBackupLocation + ''' Is not Correct'; 
                SET @p_body = 'Database Backup Will not Complete on the server </br></br>'
                    + +'Server : <b>'
                    + ( CAST(( SELECT   SERVERPROPERTY('ServerName')
                             ) AS NVARCHAR) ) + '</b></br>'
                    + ' and On the Job Name ''' + ISNULL(@Job_Name, '')
                    + ''' ' + '</b></br>' + 'and the corrupted database: <b>'
                    + ISNULL(@name, '') + '</b></br></br>' + ISNULL(@patherror,
                                                              ''); 
                PRINT @p_body;
---Send massage

                EXEC msdb.dbo.sp_send_dbmail @recipients = @p_recipients,
                    @body = @p_body, @body_format = 'HTML',
                    @subject = @p_subject;
                GOTO GOOUT;
            END;		
-------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------
----Creatation temp table to store failure data
        DECLARE @h_body AS NVARCHAR(MAX);
        DECLARE @BackupType AS VARCHAR(50);
        CREATE TABLE #JobFailed
            (
              Dbname sysname ,
              [Errormessage] VARCHAR(300) ,
              BackupType VARCHAR(30)
            );

----Strat Backup Process

        DECLARE db_cursor CURSOR FAST_FORWARD READ_ONLY FORWARD_ONLY
        FOR
            SELECT  name
            FROM    sys.databases
            WHERE   database_id >= @start_DB_ID
                    AND database_id <= @END_DB_ID
                    AND state_desc = 'ONLINE'
                    AND name NOT IN ( 'sysutility_mdw', 'distribution' )
                    AND database_id NOT IN ( SELECT *
                                             FROM   @Exceptionlist_DBs );

        DECLARE @count INT;
        OPEN db_cursor;  
        FETCH NEXT FROM db_cursor INTO @name;  
        WHILE @@FETCH_STATUS = 0
            BEGIN  
                BEGIN TRY
                    DECLARE @Return INT;
                    SET @sql = N'';

--------------------------------------------------------------------------------------------------\
-- Check Full Backup Device
                    IF ( @FULLBackup = 1 )
                        BEGIN
                            SET @count = 0; 
                            SELECT  @count = COUNT(*)
                            FROM    sys.backup_devices
                            WHERE   LOWER(name) = LOWER(@name)
                                    + LOWER('_FULLTape');
                            IF @count = 0
                                BEGIN
                                    SET @sql = @sql
                                        + N' 
				USE [master]
				EXEC master.dbo.sp_addumpdevice  @devtype = N''disk'', @logicalname = N'''
                                        + @name
                                        + '_FULLTape'', @physicalname				= N'''
                                        + @FULLTapeBackupLocation + @name
                                        + '_FullTape.bak''

				';
                                END;
                        END;
-- Execute Full Backup
                    IF @FULLoverwrite = 1 -----Overwrite
                        BEGIN 
                            SET @OverwriteTypeName = 'INIT';
                        END; 
                    ELSE ----0 Append
                        BEGIN
                            SET @OverwriteTypeName = 'NOINIT';
                        END;

                    IF ( @FULLBackup = 1
                         AND @COMPRESSION = 1
                       )
                        BEGIN
                            SET @BackupType = 'Full Backup';
                            SET @sql = @sql + N' 
						
						BACKUP DATABASE [' + @name + '] TO  [' + @name
                                + '_FULLTape] WITH NOFORMAT, '
                                + @OverwriteTypeName + ',  NAME = N''' + @name
                                + '-Full Database Backup'', SKIP, NOREWIND, NOUNLOAD, COMPRESSION,  STATS = 5
				';			
                        END;
                    ELSE
                        IF ( @FULLBackup = 1
                             AND @COMPRESSION = 0
                           )
                            BEGIN
                                SET @BackupType = 'Full Backup';
                                SET @sql = @sql + N' 
						
						BACKUP DATABASE [' + @name + '] TO  [' + @name
                                    + '_FULLTape] WITH NOFORMAT, '
                                    + @OverwriteTypeName + ',  NAME = N'''
                                    + @name
                                    + '-Full Database Backup'', SKIP, NOREWIND, NOUNLOAD,  STATS = 5
				';			
                            END;
--------------------------------------------------------------------------------------------------\
-- Check DIFF Backup Device
                    IF ( @DiffBackup = 1 )
                        BEGIN
                            SET @count = 0; 
                            SELECT  @count = COUNT(*)
                            FROM    sys.backup_devices
                            WHERE   LOWER(name) = LOWER(@name)
                                    + LOWER('_DIFFTape');
                            IF @count = 0
                                BEGIN
                                    SET @sql = @sql
                                        + N' 
				USE [master]
				EXEC master.dbo.sp_addumpdevice  @devtype = N''disk'', @logicalname = N'''
                                        + @name
                                        + '_DIFFTape'', @physicalname				= N'''
                                        + @DIFFTapeBackupLocation + @name
                                        + '_DIFFtape.bak''';
                                END;
                        END;

-- Execute DIFF Backup
                    IF @DIFFoverwrite = 1 -----Overwrite
                        BEGIN 
                            SET @OverwriteTypeName = 'INIT';
                        END; 
                    ELSE ----0 Append
                        BEGIN
                            SET @OverwriteTypeName = 'NOINIT';
                        END;
                    IF ( @DiffBackup = 1
                         AND @COMPRESSION = 1
                       )
                        BEGIN
                            SET @BackupType = 'Differentical Backup';
                            SET @sql = @sql + N' 
						
						BACKUP DATABASE [' + @name + '] TO  [' + @name
                                + '_DIFFTape] WITH NOFORMAT, '
                                + @OverwriteTypeName + ',  NAME = N''' + @name
                                + '-DIFFDifferential Database Backup'', SKIP, NOREWIND, NOUNLOAD, COMPRESSION,  STATS = 5
				';			
                        END;
                    ELSE
                        IF ( @DiffBackup = 1
                             AND @COMPRESSION = 0
                           )
                            BEGIN
                                SET @BackupType = 'Differentical Backup';
                                SET @sql = @sql + N' 
						
						BACKUP DATABASE [' + @name + '] TO  [' + @name
                                    + '_DIFFTape] WITH NOFORMAT, '
                                    + @OverwriteTypeName + ',  NAME = N'''
                                    + @name
                                    + '-DIFFDifferential Database Backup'', SKIP, NOREWIND, NOUNLOAD,  STATS = 5
				';			
                            END;
--------------------------------------------------------------------------------------------------\
-- Check LOG Backup Device
                    SELECT  @recovery_model = recovery_model
                    FROM    sys.databases
                    WHERE   name = @name;
                    IF ( @LOGBackup = 1
                         AND @recovery_model IN ( 1, 2 )
                       )
                        BEGIN
                            SET @count = 0; 
                            SELECT  @count = COUNT(*)
                            FROM    sys.backup_devices
                            WHERE   LOWER(name) = LOWER(@name)
                                    + LOWER('_LOGTape');
                            IF @count = 0
                                BEGIN
                                    SET @sql = @sql
                                        + N' 
				USE [master]
				EXEC master.dbo.sp_addumpdevice  @devtype = N''disk'', @logicalname = N'''
                                        + @name
                                        + '_LOGTape'', @physicalname				= N'''
                                        + @LOGBackupLocation + @name
                                        + '_LOGtape.bak''';
                                END;
                        END;

-- Execute LOg Backup
                    IF @LOGoverwrite = 1 -----Overwrite
                        BEGIN 
                            SET @OverwriteTypeName = 'INIT';
                        END; 
                    ELSE ----0 Append
                        BEGIN
                            SET @OverwriteTypeName = 'NOINIT';
                        END;
                    IF ( @LOGBackup = 1
                         AND @COMPRESSION = 1
                       )
                        BEGIN
                            SET @BackupType = 'Transactional Backup';
                            SET @sql = @sql + N' 
						
						BACKUP LOG [' + @name + '] TO  [' + @name
                                + '_LOGTape] WITH NOFORMAT, '
                                + @OverwriteTypeName + ',  NAME = N''' + @name
                                + '-Transactional LOG Backup'', SKIP, NOREWIND, NOUNLOAD, COMPRESSION,  STATS = 5
				';			
                        END;
                    ELSE
                        IF ( @LOGBackup = 1
                             AND @COMPRESSION = 0
                           )
                            BEGIN
                                SET @BackupType = 'Transactional Backup';
                                SET @sql = @sql + N' 
						
						BACKUP LOG [' + @name + '] TO  [' + @name
                                    + '_LOGTape] WITH NOFORMAT, '
                                    + @OverwriteTypeName + ',  NAME = N'''
                                    + @name
                                    + '-Transactional LOG Backup'', SKIP, NOREWIND, NOUNLOAD,  STATS = 5
				';			
                            END;

---------------------------------------------------------------------------------------------------------------

---Send Massage
                    SET @msg = 'Database Backup failed for the database '
                        + @name;  
                    PRINT @sql;
                    EXEC @Return = sp_executesql @sql;	
                END TRY
                BEGIN CATCH

                    IF @Return > 0
                        PRINT @Return;
                    BEGIN
                        RAISERROR (@msg,16,1) WITH LOG;
                        SET @msg = ( SELECT ERROR_MESSAGE()
                                   );
                        PRINT @msg;
                        SET @p_body = 'Database Backup failed on the server </br></br>'
                            + +'Server : <b>'
                            + ( CAST(( SELECT   SERVERPROPERTY('ServerName')
                                     ) AS NVARCHAR) ) + '</b></br>'
                            + ' and On the Job Name ''' + ISNULL(@Job_Name, '')
                            + ''' ' + '</b></br>'
                            + 'and the corrupted database: <b>' + ISNULL(@name,
                                                              '')
                            + '</b></br></br>' + ISNULL(@msg, '');
                        PRINT @p_body;
----Failure data into temp table
                        INSERT  INTO #JobFailed
                                ( Dbname, Errormessage, BackupType )
                                SELECT  @name ,
                                        @p_body ,
                                        @BackupType;


----print @p_body
                    END;
                END CATCH;
                WAITFOR DELAY '000:00:15';
                FETCH NEXT FROM db_cursor INTO @name;  
            END;  

        CLOSE db_cursor;  
        DEALLOCATE db_cursor;

--Generate the Error message into HTML table 
        SET @h_body = CAST(( SELECT td = Dbname + '</td><td>'
                                    + CAST(Errormessage AS VARCHAR(MAX))
                                    + '</td><td>'
                                    + CAST(BackupType AS VARCHAR(MAX))
                             FROM   ( SELECT    Dbname ,
                                                Errormessage ,
                                                BackupType
                                      FROM      #JobFailed
                                    ) AS d
                           FOR
                             XML PATH('tr') ,
                                 TYPE
                           ) AS VARCHAR(MAX));

        SET @h_body = '<table cellpadding="2" cellspacing="2" border="1">'
            + '<tr><th>Database </th><th>Error Message</th><th>BackupType</th></tr>'
            + REPLACE(REPLACE(@h_body, '&lt;', '<'), '&gt;', '>') + '</table>';

        DECLARE @COUNT1 INT = ( SELECT  COUNT(*)
                                FROM    #JobFailed
                              );
        IF ISNULL(@COUNT1, 0) > 0
            BEGIN
                EXEC msdb.dbo.sp_send_dbmail @recipients = @p_recipients,
                    @body = @h_body, @body_format = 'HTML',
                    @subject = @p_subject;


            END;
        DROP TABLE #JobFailed;  
        GOOUT:
    END;

GO


