/*
Total script used in the blogpost on sqlshack.com covering the hierarchyid in SQL Server
Below code only works in SQL Server 2016 - but can be altered to fit any verion of the 
SQL server from 2008 and forward.
*/

--if tables exists drop them (sql 2016 feature)
drop table if exists dbo.Employees;
drop table if exists dbo.EmployeesWithPath;

-- create parent child table structure
create table dbo.Employees (
	EmployeeId int
	,ManagerId int
	,Name varchar(20)
	,Num int
);

-- create table for new structure with hierarchyid
create table dbo.EmployeesWithPath (
	OrgPath hierarchyid
	,EmployeeId int
	,Name varchar(20)
);

-- insert demo data
insert into dbo.Employees (EmployeeId, ManagerId, Name, Num)
values
(1, null,'Ditlev', 1)
,(2, 1, 'Jane', 1)
,(3, 1, 'Kristian', 2)
,(4, 2, 'Brian', 1)
,(5, 2, 'Hanne', 2)
,(6, 2, 'Birgitte', 3)
,(7, 2, 'Jesper', 4)
,(8, 2, 'Susanne', 5)
,(9, 3, 'Ali', 1)
,(10, 3, 'Mads', 2)
,(11, 3, 'Mikkel', 3)

-- view the demo data
select * from dbo.Employees;

-- create new structure with hierarchyid using a recursive sql statement
-- insert the new structure into the table dbo.EmployeesWithPath
with emplPath (OrgPath, EmployeeId, Name) as (
select 
	hierarchyid::GetRoot() as OrgPath
	,EmployeeId
	,Name
from
	dbo.Employees e
where 1=1
	and ManagerId is null

union all

select
	cast(p.OrgPath.ToString() + cast(e.Num as varchar(30)) + '/' as hierarchyid)
	,e.EmployeeId
	,e.Name
from
	dbo.Employees e
	join emplPath p
		on e.ManagerId = p.EmployeeId
)

insert into dbo.EmployeesWithPath (OrgPath, EmployeeId, Name)
select
	e.OrgPath
	,e.EmployeeId
	,e.Name
from
	emplPath e;

-- show results of dbo.EmployeesWithPath
select * from dbo.EmployeesWithPath;

-- select and convert EmployeeId 10's OrgPath to string
select
	OrgPath
	,OrgPath.ToString() as OrgPathString
	,EmployeeId
	,Name
from
	dbo.EmployeesWithPath
where 1=1
	and EmployeeId = 10;

-- different statements from the table using ToString and GetLevel methods
select
	OrgPath
	,OrgPath.ToString() as OrgPathString
	,OrgPath.GetLevel() as OrgLevel
	,EmployeeId
	,Name
from 
	dbo.EmployeesWithPath;

-- different statements using the GetDescendants method
-- new hire reporting to the top manager
declare @maxEmployee hierarchyid
select @maxEmployee = max(OrgPath) from dbo.EmployeesWithPath where OrgPath.GetLevel() = 1

select
	OrgPath.GetDescendant(@maxEmployee, null) as NewOrgPath
	,OrgPath.GetDescendant(@maxEmployee, null).ToString() as NewOrgPathString
from
	dbo.EmployeesWithPath e
where 1=1
	and OrgPath.GetLevel() = 0

-- new hire reporting to Jane in the hierarchy
declare @mngrid hierarchyid
select @mngrid = OrgPath from dbo.EmployeesWithPath where Name = 'Jane'
declare @maxEmployee hierarchyid
select @maxEmployee = max(OrgPath) from dbo.EmployeesWithPath where OrgPath.GetAncestor(1) = @mngrid

select
	OrgPath.GetDescendant(@maxEmployee, null) as NewOrgPath
	,OrgPath.GetDescendant(@maxEmployee, null).ToString() as NewOrgPathString
from
	dbo.EmployeesWithPath e
where 1=1
	and OrgPath = @mngrid

-- dynamic enter new values
-- can easily be converted to a stored procedure
declare @mgrid int = 3
declare @emplid int = 12
declare @name varchar(20) = 'Rasmus'

declare @mgrOrgPath hierarchyid, @lastOrgPath hierarchyid
select 
	@mgrOrgPath = OrgPath 
from 
	dbo.EmployeesWithPath
where 1=1
	and EmployeeId = @mgrid

begin tran
	select 
		@lastOrgPath = max(OrgPath)
	from
		dbo.EmployeesWithPath
	where 1=1
		and OrgPath.GetAncestor(1) = @mgrOrgPath;

	insert into dbo.EmployeesWithPath (OrgPath, EmployeeId, Name)
	values (@mgrOrgPath.GetDescendant(@lastOrgPath, null), @emplid, @name);

commit tran

select
	OrgPath
	,OrgPath.ToString() as OrgPathString
	,EmployeeId
	,Name
from 
	dbo.EmployeesWithPath 
where 1=1
	and name = 'Rasmus';

-- optimization
-- add computed level column
alter table dbo.EmployeesWithPath
add OrgPathLevel as OrgPath.GetLevel();

-- create unique index in OrgPathLevel and OrgPath
create unique index unci_Employee on dbo.EmployeeswithPath(OrgPathLevel, OrgPath);

-- create unique index on EmployeeId
create unique index uncli_EmployeeId on dbo.EmployeeswithPath(EmployeeId);

-- Get all elements referencing to Jane in the hierarchy
declare @employee hierarchyid
select 
	@employee = OrgPath 
from 
	dbo.EmployeesWithPath 
where 1=1
	and Name = 'Jane'

select
	OrgPath
	,OrgPath.ToString() as OrgPathString
	,OrgPath.GetLevel() as OrgPathLevel
	,EmployeeId
	,Name
from
	dbo.EmployeesWithPath
where 1=1
	and OrgPath.IsDescendantOf(@employee) = 1;