SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Index Overview_Longest Running Queries ''<Add Server/Database Names>'''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_LongestQueries
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server Name</th>' +
N'<th>DB Name</th>' +
N'<th>Query Name</th>' +
N'<th>Execution Count</th>' +
N'<th>Max Elasped Time (milliseconds)</th>' +
N'<th>Avg Elsaped Time (milliseconds)</th>' +
N'</tr>' +
CAST ( ( SELECT td=[ServerName],''
,td=[DBName],''
,td=[QueryName],''
,td=[ExecutionCount],''
,td=MaxElapsedTime,''
,td=AvgElapsedTime,''
FROM DBA_Monitoring.dbo.IndexOverview_LongestQueries
order by ServerName, DBName, QueryName, ExecutionCount
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your mail profile here>',
@recipients = '<add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML' ;

END