SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Index Overview_Duplicate Index ''<Add Server/Database Names>'''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_DuplicateIndex
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server Name</th>' +
N'<th>DB Name</th>' +
N'<th>Table Name</th>' +
N'<th>Overlapping Index</th>' +
N'<th>Col1</th>' +
N'<th>Col2</th>' +
N'<th>Col3</th>' +
N'<th>Col4</th>' +
N'<th>Col5</th>' +
N'<th>Col6</th>' +
N'<th>Col7</th>' +
N'<th>Col8</th>' +
N'<th>Col9</th>' +
N'<th>Col10</th>' +
N'</tr>' +
CAST ( ( SELECT td=[servername],''
,td=[dbname],''
,td=[OverlappingIndex],''
,td=[Col1],''
,td=[Col2],''
,td=[Col3],''
,td=[Col4],''
,td=[Col5],''
,td=[Col6],''
,td=[Col7],''
,td=[Col8],''
,td=[Col9],''
,td=[Col10],''
FROM DBA_Monitoring.dbo.IndexOverview_DuplicateIndex
ORDER BY
	ServerName, DBName, TableName,IndexName
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your mail profile here>',
@recipients = '<add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML' ;

END