SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Index Overview_Missing Index ''<Add Server/Database Names>'''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_MissingIndex
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server Name</th>' +
N'<th>DB Name</th>' +
N'<th>Avg Estimated Impact (milliseconds)</th>' +
N'<th>Last User Seek</th>' +
N'<th>Table Name</th>' +
N'<th>Create Statement</th>' +
N'</tr>' +
CAST ( ( SELECT td=[ServerName],''
,td=[DBName],''
,td=Cast([Avg_Estimated_Impact] as varchar(25)),''
,td=[Last_User_Seek],''
,td=[TableName],''
,td=[Create_Statement],''
FROM DBA_Monitoring.dbo.IndexOverview_MissingIndex
order by ServerName, DBName, TableName
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your mail profile here>',
@recipients = '<add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML' ;

END