SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Index Overview_Index Reads with Counts ''<Add Server/Database Names>'''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverviewReadsWithCounts
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server Name</th>' +
N'<th>DB Name</th>' +
N'<th>Object</th>' +
N'<th>Execution Count</th>' +
N'<th>Total Logical Reads</th>' +
N'<th>Total Physical Reads</th>' +
N'</tr>' +
CAST ( ( SELECT td=[ServerName],''
,td=[Database],''
,td=[Object],''
,td=[execution_count],''
,td=total_logical_reads,''
,td=total_physical_reads,''
FROM DBA_Monitoring.dbo.IndexOverviewReadsWithCounts
order by ServerName, [Database], [Object]
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your mail profile here>',
@recipients = '<add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML' ;

END