SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Index Overview_Fragmentation Levels ''<Add Server/Database Names>'''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_FragLevels
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server Name</th>' +
N'<th>DB Name</th>' +
N'<th>Table</th>' +
N'<th>Index</th>' +
N'<th>Fragmentation %</th>' +
N'<th>Page Count</th>' +
N'</tr>' +
CAST ( ( SELECT td=[ServerName],''
,td=[DBname],''
,td=[Table],''
,td=IsNull([Index], 'HEAP - no clustered index'),''
,td=convert(varchar, round([avg_fragmentation_in_percent], 2)),''
,td=[page_count],''
FROM DBA_Monitoring.dbo.IndexOverview_FragLevels
order by ServerName, DBName, [Table], [Index]
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your mail profile here>',
@recipients = '<add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML' ;

END