# ---------------------------------------------------------------------------
### <Script>
### <Author>
### Chad Miller 
### </Author>
### <Description>
### Writes Database Space information to specified table
### </Description>
### <Usage>
### Write-DbSpaceToDb.ps1 'Z002\SQL2K8' spacedm
### </Usage>
### </Script>
# ---------------------------------------------------------------------------
param($destServer, $destdb)

#######################
function Get-SqlData
{
    param([string]$serverName=$(throw 'serverName is required.'), [string]$databaseName=$(throw 'databaseName is required.'),
          [string]$query=$(throw 'query is required.'))
 
    Write-Verbose "Get-SqlData serverName:$serverName databaseName:$databaseName query:$query"
 
    $connString = "Server=$serverName;Database=$databaseName;Integrated Security=SSPI;"
    $da = New-Object "System.Data.SqlClient.SqlDataAdapter" ($query,$connString)
    $dt = New-Object "System.Data.DataTable"
    [void]$da.fill($dt)
    $dt
 
} #Get-SqlData

#######################
function Get-DbSpace
{
    param($srcServer)

$qry = @"
CREATE TABLE #output(
server_name varchar(128),
dbname varchar(128),
physical_name varchar(260),
dt datetime,
file_group_name varchar(128),
size_mb int,
free_mb int) 

exec sp_MSforeachdb @command1=
'USE [?]; INSERT #output
SELECT CAST(SERVERPROPERTY(''ServerName'') AS varchar(128)) AS server_name,
''?'' AS dbname,
f.filename AS physical_name,
CAST(FLOOR(CAST(getdate() AS float)) AS datetime) AS dt,
g.groupname,
CAST (size*8.0/1024.0 AS int) AS ''size_mb'',
CAST((size - FILEPROPERTY(f.name,''SpaceUsed''))*8.0/1024.0 AS int) AS ''free_mb''
FROM sysfiles f
JOIN sysfilegroups g
ON f.groupid = g.groupid'

SELECT * FROM #output
"@
    Get-SqlData $srcServer 'master' $qry

}# Get-DbSpace

#######################
function Write-DataTableToDatabase
{ 
    param ($dataTable,$destTbl)

    $connectionString = "Data Source=$destServer;Integrated Security=true;Initial Catalog=$destdb;"
    $bulkCopy = new-object ("Data.SqlClient.SqlBulkCopy") $connectionString
    $bulkCopy.DestinationTableName = "$destTbl"
    $bulkCopy.WriteToServer($dataTable)

}# Write-DataTableToDatabase

#######################
## MAIN             ##
#######################

Get-SqlData $destServer $destDb  "SELECT server_name FROM (
SELECT DISTINCT groups.name AS 'server_group_name',svr.server_name AS 'server_name'
FROM msdb.dbo.sysmanagement_shared_server_groups_internal groups 
INNER JOIN msdb.dbo.sysmanagement_shared_registered_servers_internal svr
 ON groups.server_group_id = svr.server_group_id
 WHERE groups.name like 'SQL2012') a" |
foreach {
    $dataTable = Get-DBSpace $_.server_name
    if ($dataTable)
    { Write-DataTableToDatabase $dataTable 'db_space' }
}
